/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.views;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Locale;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.views.AbstractLinkedSonarWebView;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;

public class RuleDescriptionWebView
extends AbstractLinkedSonarWebView<IMarker>
implements ISelectionListener {
    public static final String ID = "org.sonarlint.eclipse.ui.views.RuleDescriptionWebView";

    private static String css(Browser b) {
        return "<style type=\"text/css\">body { font-family: Helvetica Neue,Segoe UI,Helvetica,Arial,sans-serif; font-size: 13px; line-height: 1.23076923; color: " + RuleDescriptionWebView.hexColor(b.getForeground()) + ";background-color: " + RuleDescriptionWebView.hexColor(b.getBackground()) + "}" + "h1 { color: " + RuleDescriptionWebView.hexColor(b.getForeground()) + ";font-size: 14px;font-weight: 500; }" + "h2 { line-height: 24px; color: " + RuleDescriptionWebView.hexColor(b.getForeground()) + ";}" + "a { border-bottom: 1px solid #cae3f2; color: #236a97; cursor: pointer; outline: none; text-decoration: none; transition: all .2s ease;}" + ".rule-desc { line-height: 1.5;}" + ".rule-desc { line-height: 1.5;}" + ".rule-desc h2 { font-size: 16px; font-weight: 400;}" + ".rule-desc code { padding: .2em .45em; margin: 0; background-color: " + RuleDescriptionWebView.hexColor(b.getForeground(), 20) + "; border-radius: 3px; white-space: nowrap;}" + ".rule-desc pre { padding: 10px; border-top: 1px solid " + RuleDescriptionWebView.hexColor(b.getForeground(), 100) + "; border-bottom: 1px solid " + RuleDescriptionWebView.hexColor(b.getForeground(), 100) + "; line-height: 18px; overflow: auto;}" + ".rule-desc code, .rule-desc pre { font-family: Consolas,Liberation Mono,Menlo,Courier,monospace; font-size: 12px;}" + ".rule-desc ul { padding-left: 40px; list-style: disc;}</style>";
    }

    @Override
    protected void open(IMarker element) {
        Browser b = this.getBrowser();
        if (b != null) {
            try {
                RuleDetails ruleDetails;
                String ruleName = element.getAttribute("rulename").toString();
                String ruleKey = element.getAttribute("rulekey").toString();
                ISonarLintIssuable issuable = (ISonarLintIssuable)Adapters.adapt((Object)element.getResource(), ISonarLintIssuable.class);
                ISonarLintProject p = issuable.getProject();
                SonarLintProjectConfiguration configuration = SonarLintProjectConfiguration.read((IScopeContext)p.getScopeContext());
                if (!configuration.isBound()) {
                    ruleDetails = SonarLintCorePlugin.getInstance().getDefaultSonarLintClientFacade().getRuleDescription(ruleKey);
                } else {
                    IServer server = SonarLintCorePlugin.getServersManager().getServer(configuration.getServerId());
                    if (server == null) {
                        super.showMessage("Project " + p.getName() + " is linked to an unknown server: " + configuration.getServerId() + ". Please update configuration.");
                        return;
                    }
                    ruleDetails = server.getRuleDescription(ruleKey);
                }
                if (ruleDetails != null) {
                    String htmlDescription = ruleDetails.getHtmlDescription();
                    String extendedDescription = ruleDetails.getExtendedDescription();
                    if (!extendedDescription.isEmpty()) {
                        htmlDescription = String.valueOf(htmlDescription) + "<div>" + extendedDescription + "</div>";
                    }
                    String type = ruleDetails.getType();
                    String typeImg64 = RuleDescriptionWebView.getAsBase64(SonarLintImages.getTypeImage(type));
                    String severity = ruleDetails.getSeverity();
                    String severityImg64 = RuleDescriptionWebView.getAsBase64(SonarLintImages.getSeverityImage(severity));
                    super.showHtml("<!doctype html><html><head>" + RuleDescriptionWebView.css(b) + "</head><body><h1><big>" + ruleName + "</big> (" + ruleKey + ")</h1>" + "<div>" + "<img style=\"padding-bottom: 1px;vertical-align: middle\" width=\"16\" height=\"16\" alt=\"" + type + "\" src=\"data:image/gif;base64," + typeImg64 + "\">&nbsp;" + RuleDescriptionWebView.clean(type) + "&nbsp;" + "<img style=\"padding-bottom: 1px;vertical-align: middle\" width=\"16\" height=\"16\" alt=\"" + severity + "\" src=\"data:image/gif;base64," + severityImg64 + "\">&nbsp;" + RuleDescriptionWebView.clean(severity) + "</div>" + "<div class=\"rule-desc\">" + htmlDescription + "</div></body></html>");
                } else {
                    super.showHtml("No rule description available");
                }
            }
            catch (CoreException e) {
                SonarLintLogger.get().error("Unable to open rule description", (Throwable)e);
            }
        }
    }

    private static String clean(String txt) {
        return StringUtils.capitalize((String)txt.toLowerCase(Locale.ENGLISH).replace("_", " "));
    }

    private static String getAsBase64(Image image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save((OutputStream)out, 5);
        return Base64.getEncoder().encodeToString(out.toByteArray());
    }

    private static String hexColor(Color color) {
        return RuleDescriptionWebView.hexColor(color, RuleDescriptionWebView.getAlpha(color));
    }

    private static int getAlpha(Color c) {
        try {
            Method m = Color.class.getMethod("getAlpha", new Class[0]);
            return (Integer)m.invoke((Object)c, new Object[0]);
        }
        catch (Exception exception) {
            return 255;
        }
    }

    private static String hexColor(Color color, Integer alpha) {
        return "rgba(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + (double)alpha.intValue() / 255.0 + ")";
    }

    @Override
    protected IMarker findSelectedElement(IWorkbenchPart part, ISelection selection) {
        return RuleDescriptionWebView.findSelectedSonarIssue(selection);
    }
}

