/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.core.resource.ISonarLintProjectContainer;

public final class SelectionUtils {
    private SelectionUtils() {
    }

    public static Object getSingleElement(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    public static Set<ISonarLintProject> allSelectedProjects(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        HashSet<ISonarLintProject> selectedProjects = new HashSet<ISonarLintProject>();
        if (selection instanceof IStructuredSelection) {
            List elems = ((IStructuredSelection)selection).toList();
            for (Object elem : elems) {
                SelectionUtils.collectProjects(selectedProjects, elem);
            }
        }
        return selectedProjects;
    }

    private static void collectProjects(Set<ISonarLintProject> selectedProjects, Object elem) {
        ISonarLintProjectContainer container = (ISonarLintProjectContainer)Adapters.adapt((Object)elem, ISonarLintProjectContainer.class);
        if (container != null) {
            selectedProjects.addAll(container.projects());
            return;
        }
        ISonarLintProject project = (ISonarLintProject)Adapters.adapt((Object)elem, ISonarLintProject.class);
        if (project != null) {
            selectedProjects.add(project);
            return;
        }
    }

    public static Set<ISonarLintFile> allSelectedFiles(ISelection selection) {
        HashSet<ISonarLintFile> selectedFiles = new HashSet<ISonarLintFile>();
        if (selection instanceof IStructuredSelection) {
            List elems = ((IStructuredSelection)selection).toList();
            for (Object elem : elems) {
                SelectionUtils.collectFiles(selectedFiles, elem);
            }
        }
        return selectedFiles;
    }

    private static void collectFiles(Set<ISonarLintFile> selectedFiles, Object elem) {
        ISonarLintProjectContainer container = (ISonarLintProjectContainer)Adapters.adapt((Object)elem, ISonarLintProjectContainer.class);
        if (container != null) {
            container.projects().stream().filter(ISonarLintProject::isOpen).forEach(p -> {
                boolean bl = selectedFiles.addAll(p.files());
            });
            return;
        }
        ISonarLintProject project = (ISonarLintProject)Adapters.adapt((Object)elem, ISonarLintProject.class);
        if (project != null) {
            selectedFiles.addAll(project.files());
            return;
        }
        ISonarLintFile file = (ISonarLintFile)Adapters.adapt((Object)elem, ISonarLintFile.class);
        if (file != null) {
            selectedFiles.add(file);
            return;
        }
    }
}

