/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.util;

import java.util.HashMap;
import javax.annotation.CheckForNull;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;

public final class PlatformUtils {
    private PlatformUtils() {
    }

    public static void openEditor(IFile file) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
        }
        catch (PartInitException e) {
            SonarLintLogger.get().error(e.getMessage(), (Throwable)e);
        }
    }

    public static void openEditor(IFile file, Integer line) {
        if (line == null) {
            PlatformUtils.openEditor(file);
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>(1);
            map.put("lineNumber", line);
            IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttributes(map);
            IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            SonarLintLogger.get().error(e.getMessage(), (Throwable)e);
        }
    }

    @CheckForNull
    public static IEditorPart findEditor(ISonarLintFile file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow win = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = win.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorPart result = PlatformUtils.findInFileEditorInput(file, page);
                if (result != null) {
                    return result;
                }
                result = PlatformUtils.findInOtherEditors(file, page);
                if (result != null) {
                    return result;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @CheckForNull
    private static IEditorPart findInFileEditorInput(ISonarLintFile file, IWorkbenchPage page) {
        if (file.getResource() instanceof IFile) {
            IEditorReference[] references = page.findEditors((IEditorInput)new FileEditorInput((IFile)file.getResource()), null, 1);
            if (references.length == 0) {
                return null;
            }
            return references[0].getEditor(false);
        }
        return null;
    }

    @CheckForNull
    private static IEditorPart findInOtherEditors(ISonarLintFile file, IWorkbenchPage page) {
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISonarLintFile editorSlFile;
            IFile editorFile;
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart part = ref.getEditor(false);
            if (part != null && (editorFile = (IFile)Adapters.adapt((Object)part.getEditorInput(), IFile.class)) != null && (editorSlFile = (ISonarLintFile)Adapters.adapt((Object)editorFile, ISonarLintFile.class)) != null && editorSlFile.equals(file)) {
                return part;
            }
            ++n2;
        }
        return null;
    }
}

