/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.ServerUpdateJob;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.Server;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;
import org.sonarlint.eclipse.ui.internal.server.actions.JobUtils;
import org.sonarlint.eclipse.ui.internal.server.wizard.AuthMethodWizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.ConnectionTypeWizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.EndWizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.OrganizationWizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionModel;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionTestJob;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerIdWizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.TokenWizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.UrlWizardPage;
import org.sonarlint.eclipse.ui.internal.server.wizard.UsernamePasswordWizardPage;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteOrganization;
import org.sonarsource.sonarlint.core.client.api.exceptions.UnsupportedServerException;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;

public class ServerConnectionWizard
extends Wizard
implements INewWizard,
IPageChangingListener {
    private final ServerConnectionModel model;
    private final ConnectionTypeWizardPage connectionTypeWizardPage;
    private final UrlWizardPage urlPage;
    private final AuthMethodWizardPage authMethodPage;
    private final UsernamePasswordWizardPage credentialsPage;
    private final TokenWizardPage tokenPage;
    private final OrganizationWizardPage orgPage;
    private final ServerIdWizardPage serverIdPage;
    private final EndWizardPage endPage;
    private final IServer editedServer;

    private ServerConnectionWizard(String title, ServerConnectionModel model, IServer editedServer) {
        this.model = model;
        this.editedServer = editedServer;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(title);
        this.setHelpAvailable(false);
        this.connectionTypeWizardPage = new ConnectionTypeWizardPage(model);
        this.urlPage = new UrlWizardPage(model);
        this.authMethodPage = new AuthMethodWizardPage(model);
        this.credentialsPage = new UsernamePasswordWizardPage(model);
        this.tokenPage = new TokenWizardPage(model);
        this.orgPage = new OrganizationWizardPage(model);
        this.serverIdPage = new ServerIdWizardPage(model);
        this.endPage = new EndWizardPage(model);
    }

    public ServerConnectionWizard() {
        this("Connect to a SonarQube Server", new ServerConnectionModel(), null);
    }

    private ServerConnectionWizard(String serverId) {
        this();
        this.model.setServerId(serverId);
    }

    private ServerConnectionWizard(IServer sonarServer) {
        this("Edit connection to a SonarQube Server", new ServerConnectionModel(sonarServer), sonarServer);
    }

    public static WizardDialog createDialog(Shell parent) {
        return new WizardDialog(parent, (IWizard)new ServerConnectionWizard());
    }

    public static WizardDialog createDialog(Shell parent, String serverId) {
        return new WizardDialog(parent, (IWizard)new ServerConnectionWizard(serverId));
    }

    public static WizardDialog createDialog(Shell parent, IServer sonarServer) {
        return new WizardDialog(parent, (IWizard)new ServerConnectionWizard(sonarServer));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public IWizardPage getStartingPage() {
        if (!this.model.isEdit()) {
            return this.connectionTypeWizardPage;
        }
        return this.firstPageAfterConnectionType();
    }

    public void addPages() {
        if (!this.model.isEdit()) {
            this.addPage((IWizardPage)this.connectionTypeWizardPage);
            this.addPage((IWizardPage)this.serverIdPage);
        }
        this.addPage((IWizardPage)this.urlPage);
        this.addPage((IWizardPage)this.authMethodPage);
        this.addPage((IWizardPage)this.credentialsPage);
        this.addPage((IWizardPage)this.tokenPage);
        this.addPage((IWizardPage)this.orgPage);
        this.addPage((IWizardPage)this.endPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.connectionTypeWizardPage) {
            return this.firstPageAfterConnectionType();
        }
        if (page == this.urlPage) {
            return this.authMethodPage;
        }
        if (page == this.authMethodPage) {
            return this.model.getAuthMethod() == ServerConnectionModel.AuthMethod.PASSWORD ? this.credentialsPage : this.tokenPage;
        }
        if (page == this.credentialsPage || page == this.tokenPage) {
            return this.orgPage;
        }
        if (page == this.orgPage) {
            return this.model.isEdit() ? this.endPage : this.serverIdPage;
        }
        if (page == this.serverIdPage) {
            return this.endPage;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return null;
    }

    private IWizardPage firstPageAfterConnectionType() {
        return this.model.getConnectionType() == ServerConnectionModel.ConnectionType.SONARCLOUD ? this.tokenPage : this.urlPage;
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage == this.endPage;
    }

    public boolean performFinish() {
        IServer server;
        if (this.model.isEdit() && !this.testConnection(this.model.getOrganization())) {
            return false;
        }
        if (this.model.isEdit()) {
            this.editedServer.updateConfig(this.model.getServerUrl(), this.model.getOrganization(), this.model.getUsername(), this.model.getPassword(), this.model.getNotificationsEnabled());
            server = this.editedServer;
            ServerUpdateJob job = new ServerUpdateJob(server);
            final List boundProjects = server.getBoundProjects();
            if (this.model.getNotificationsSupported() && this.model.getNotificationsEnabled() && !boundProjects.isEmpty()) {
                Job subscribeToNotificationsJob = new Job("Subscribe to notifications"){

                    protected IStatus run(IProgressMonitor monitor) {
                        boundProjects.forEach(SonarLintUiPlugin::subscribeToNotifications);
                        return Status.OK_STATUS;
                    }
                };
                JobUtils.scheduleAfterSuccess((Job)job, () -> ((Job)subscribeToNotificationsJob).schedule());
            } else {
                boundProjects.forEach(SonarLintUiPlugin::unsubscribeToNotifications);
            }
            job.schedule();
        } else {
            server = SonarLintCorePlugin.getServersManager().create(this.model.getServerId(), this.model.getServerUrl(), this.model.getOrganization(), this.model.getUsername(), this.model.getPassword(), this.model.getNotificationsEnabled());
            SonarLintCorePlugin.getServersManager().addServer(server, this.model.getUsername(), this.model.getPassword());
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.sonarlint.eclipse.ui.ServersView");
            }
            catch (PartInitException e) {
                SonarLintLogger.get().error("Unable to open server view", (Throwable)e);
            }
        }
        ServerUpdateJob j = new ServerUpdateJob(server);
        j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    JobUtils.scheduleAnalysisOfOpenFilesInBoundProjects(server, TriggerType.BINDING_CHANGE);
                }
            }
        });
        j.schedule();
        return true;
    }

    public void handlePageChanging(PageChangingEvent event) {
        boolean advance;
        WizardPage currentPage = (WizardPage)event.getCurrentPage();
        boolean bl = advance = this.getNextPage((IWizardPage)currentPage) == event.getTargetPage();
        if (advance && (currentPage == this.credentialsPage || currentPage == this.tokenPage) && !this.testConnection(null)) {
            event.doit = false;
            return;
        }
        if (advance && event.getTargetPage() == this.orgPage) {
            event.doit = this.tryLoadOrganizations(currentPage);
            return;
        }
        if (advance && currentPage == this.orgPage && this.model.hasOrganizations() && !this.testConnection(this.model.getOrganization())) {
            event.doit = false;
            return;
        }
        if (advance && event.getTargetPage() == this.endPage) {
            boolean notificationsSupported = Server.checkNotificationsSupported((String)this.model.getServerUrl(), (String)this.model.getOrganization(), (String)this.model.getUsername(), (String)this.model.getPassword());
            this.endPage.setNotificationsSupported(notificationsSupported);
            this.model.setNotificationsSupported(notificationsSupported);
            if (notificationsSupported && !this.model.isEdit()) {
                this.model.setNotificationsEnabled(true);
            }
        }
    }

    private boolean tryLoadOrganizations(WizardPage currentPage) {
        currentPage.setMessage(null);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            TextSearchIndex organizationsIndex = Server.getOrganizationsIndex((String)ServerConnectionWizard.this.model.getServerUrl(), (String)ServerConnectionWizard.this.model.getUsername(), (String)ServerConnectionWizard.this.model.getPassword(), (IProgressMonitor)monitor);
                            ServerConnectionWizard.this.model.setOrganizationsIndex((TextSearchIndex<RemoteOrganization>)organizationsIndex);
                        }
                        catch (UnsupportedServerException unsupportedServerException) {
                            ServerConnectionWizard.this.model.setOrganizationsIndex(null);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            SonarLintLogger.get().debug("Unable to download organizations", e.getCause());
            currentPage.setMessage(e.getCause().getMessage(), 3);
            this.model.setOrganizationsIndex(null);
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.model.setOrganizationsIndex(null);
            return false;
        }
        return true;
    }

    private boolean testConnection(@Nullable String organization) {
        Status status;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        try {
            ServerConnectionTestJob testJob = new ServerConnectionTestJob(this.model.getServerUrl(), organization, this.model.getUsername(), this.model.getPassword());
            this.getContainer().run(true, true, (IRunnableWithProgress)testJob);
            status = testJob.getStatus();
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        catch (Exception e1) {
            status = new Status(4, "org.sonarlint.eclipse.ui", String.valueOf(Messages.ServerLocationWizardPage_msg_error) + " " + e1.getMessage(), (Throwable)e1);
        }
        String message = status.getMessage();
        if (status.getSeverity() != 0) {
            ((WizardPage)currentPage).setMessage(message, 3);
            return false;
        }
        return true;
    }
}

