/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.ui.internal.server.wizard.ModelObject;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteOrganization;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;

public class ServerConnectionModel
extends ModelObject {
    private static final String ERROR_READING_SECURE_STORAGE = "Error reading secure storage";
    public static final String PROPERTY_CONNECTION_TYPE = "connectionType";
    public static final String PROPERTY_SERVER_URL = "serverUrl";
    public static final String PROPERTY_AUTH_METHOD = "authMethod";
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_ORGANIZATION = "organization";
    public static final String PROPERTY_SERVER_ID = "serverId";
    public static final String PROPERTY_NOTIFICATIONS_ENABLED = "notificationsEnabled";
    private final boolean edit;
    private ConnectionType connectionType = ConnectionType.SONARCLOUD;
    private AuthMethod authMethod = AuthMethod.TOKEN;
    private String serverId;
    private String serverUrl = "https://sonarcloud.io";
    private String organization;
    private String username;
    private String password;
    private TextSearchIndex<RemoteOrganization> organizationsIndex;
    private boolean notificationsSupported;
    private boolean notificationsEnabled;

    public ServerConnectionModel() {
        this.edit = false;
    }

    public ServerConnectionModel(IServer server) {
        this.edit = true;
        this.serverId = server.getId();
        this.serverUrl = server.getHost();
        this.connectionType = "https://sonarcloud.io".equals(this.serverUrl) ? ConnectionType.SONARCLOUD : ConnectionType.ONPREMISE;
        this.organization = server.getOrganization();
        if (server.hasAuth()) {
            try {
                this.username = ServersManager.getUsername((IServer)server);
                this.password = ServersManager.getPassword((IServer)server);
            }
            catch (StorageException e) {
                SonarLintLogger.get().error(ERROR_READING_SECURE_STORAGE, (Throwable)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ERROR_READING_SECURE_STORAGE, (String)("Unable to read password from secure storage: " + e.getMessage()));
            }
            this.authMethod = StringUtils.isBlank((String)this.password) ? AuthMethod.TOKEN : AuthMethod.PASSWORD;
        }
        this.notificationsEnabled = server.areNotificationsEnabled();
    }

    public boolean isEdit() {
        return this.edit;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType type) {
        ConnectionType old = this.connectionType;
        this.connectionType = type;
        this.firePropertyChange(PROPERTY_CONNECTION_TYPE, (Object)old, (Object)this.connectionType);
        if (type == ConnectionType.ONPREMISE) {
            this.setServerUrl(null);
        } else {
            this.setServerUrl("https://sonarcloud.io");
            this.setAuthMethod(AuthMethod.TOKEN);
        }
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthMethod authMethod) {
        AuthMethod old = this.authMethod;
        this.authMethod = authMethod;
        this.firePropertyChange(PROPERTY_AUTH_METHOD, (Object)old, (Object)this.authMethod);
        this.setUsername(null);
        this.setPassword(null);
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        String old = this.serverId;
        this.serverId = serverId;
        this.firePropertyChange(PROPERTY_SERVER_ID, old, this.serverId);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        String old = this.serverUrl;
        this.serverUrl = serverUrl;
        this.firePropertyChange(PROPERTY_SERVER_URL, old, this.serverUrl);
        this.suggestServerId();
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        String old = this.organization;
        this.organization = organization;
        this.firePropertyChange(PROPERTY_ORGANIZATION, old, this.organization);
        this.suggestServerId();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        String old = this.username;
        this.username = username;
        this.firePropertyChange(PROPERTY_USERNAME, old, this.username);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        String old = this.password;
        this.password = password;
        this.firePropertyChange(PROPERTY_PASSWORD, old, this.password);
    }

    @CheckForNull
    public TextSearchIndex<RemoteOrganization> getOrganizationsIndex() {
        return this.organizationsIndex;
    }

    public boolean hasOrganizations() {
        return this.organizationsIndex != null && this.organizationsIndex.size() > 1;
    }

    public void setOrganizationsIndex(@Nullable TextSearchIndex<RemoteOrganization> organizationsIndex) {
        this.organizationsIndex = organizationsIndex;
    }

    private void suggestServerId() {
        if (!this.edit) {
            try {
                String suggestedId;
                if (this.connectionType == ConnectionType.SONARCLOUD) {
                    suggestedId = "SonarCloud";
                } else {
                    URL url = new URL(this.getServerUrl());
                    suggestedId = url.getHost();
                }
                if (StringUtils.isNotBlank((String)this.organization)) {
                    suggestedId = String.valueOf(suggestedId) + "/" + this.organization;
                }
                this.setServerId(suggestedId);
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    public boolean getNotificationsSupported() {
        return this.notificationsSupported;
    }

    public void setNotificationsSupported(boolean value) {
        this.notificationsSupported = value;
    }

    public boolean getNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    public void setNotificationsEnabled(boolean value) {
        boolean old = this.notificationsEnabled;
        this.notificationsEnabled = value;
        this.firePropertyChange(PROPERTY_NOTIFICATIONS_ENABLED, old, this.notificationsEnabled);
    }

    public static enum AuthMethod {
        TOKEN,
        PASSWORD;

    }

    public static enum ConnectionType {
        SONARCLOUD,
        ONPREMISE;

    }
}

