/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionModel;

public class ConnectionTypeWizardPage
extends WizardPage {
    private final ServerConnectionModel model;

    public ConnectionTypeWizardPage(ServerConnectionModel model) {
        super("server_type_page", "Choose connection type", SonarLintImages.IMG_WIZBAN_NEW_SERVER);
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite radioButtonGroupContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        radioButtonGroupContainer.setLayout((Layout)layout);
        Button sonarCloudButton = new Button(radioButtonGroupContainer, 16);
        sonarCloudButton.setImage(SonarLintImages.IMG_SONARCLOUD_LOGO);
        Button onPremiseButton = new Button(radioButtonGroupContainer, 16);
        onPremiseButton.setImage(SonarLintImages.IMG_SONARQUBE_LOGO);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        Link sonarCloudLabel = new Link(radioButtonGroupContainer, 64);
        sonarCloudLabel.setText("Connect to <a>the online service</a>");
        sonarCloudLabel.setLayoutData((Object)gd);
        sonarCloudLabel.addListener(13, e -> {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL("https://sonarcloud.io"));
            }
            catch (MalformedURLException | PartInitException ex) {
                SonarLintLogger.get().error("Unable to open the browser", ex);
            }
        });
        Label onPremiseLabel = new Label(radioButtonGroupContainer, 64);
        onPremiseLabel.setText("Connect to a server");
        onPremiseLabel.setLayoutData((Object)gd);
        ISWTObservableValue sonarCloudSelection = WidgetProperties.selection().observe((Widget)sonarCloudButton);
        ISWTObservableValue onPremSelection = WidgetProperties.selection().observe((Widget)onPremiseButton);
        SelectObservableValue selectObservable = new SelectObservableValue(ServerConnectionModel.ConnectionType.class);
        selectObservable.addOption((Object)ServerConnectionModel.ConnectionType.SONARCLOUD, (IObservableValue)sonarCloudSelection);
        selectObservable.addOption((Object)ServerConnectionModel.ConnectionType.ONPREMISE, (IObservableValue)onPremSelection);
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue((IObservableValue)selectObservable, PojoProperties.value((String)"connectionType").observe((Object)this.model));
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        this.setControl((Control)radioButtonGroupContainer);
    }
}

