/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.server.DeleteServerDialog;
import org.sonarlint.eclipse.ui.internal.server.UnbindProjectDialog;

public class ServerOrProjectDeleteAction
extends SelectionProviderAction {
    private List<IServer> selectedServers;
    private List<ISonarLintProject> selectedProjects;
    private Shell shell;

    public ServerOrProjectDeleteAction(Shell shell, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionDelete);
        this.shell = shell;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.selectedServers = new ArrayList<IServer>();
        this.selectedProjects = new ArrayList<ISonarLintProject>();
        for (Object obj : sel) {
            if (obj instanceof IServer) {
                IServer server = (IServer)obj;
                this.selectedServers.add(server);
                continue;
            }
            if (obj instanceof ISonarLintProject) {
                ISonarLintProject project = (ISonarLintProject)obj;
                this.selectedProjects.add(project);
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.selectedServers.isEmpty() ^ this.selectedProjects.isEmpty());
        this.setText(!this.selectedServers.isEmpty() ? Messages.actionDelete : Messages.actionUnbind);
    }

    public void run() {
        MessageDialog dsd;
        IStructuredSelection sel;
        if ((this.selectedServers == null || this.selectedProjects == null) && (sel = this.getStructuredSelection()) != null) {
            this.selectionChanged(sel);
        }
        if (this.selectedServers != null && !this.selectedServers.isEmpty()) {
            dsd = new DeleteServerDialog(this.shell, this.selectedServers);
            dsd.open();
        } else if (this.selectedProjects != null && !this.selectedProjects.isEmpty()) {
            dsd = new UnbindProjectDialog(this.shell, this.selectedProjects);
            dsd.open();
        }
    }
}

