/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.bind.BindProjectsWizard;

public class ProjectChangeBindingAction
extends SelectionProviderAction {
    private final Shell shell;
    private List<ISonarLintProject> selectedProjects;

    public ProjectChangeBindingAction(Shell shell, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionChangeBinding);
        this.shell = shell;
        this.setImageDescriptor(SonarLintImages.SYNCED_IMG);
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        this.selectedProjects = new ArrayList<ISonarLintProject>();
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof ISonarLintProject) {
                ISonarLintProject project = (ISonarLintProject)obj;
                this.selectedProjects.add(project);
                enabled = true;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IStructuredSelection sel;
        if (this.selectedProjects == null && (sel = this.getStructuredSelection()) != null) {
            this.selectionChanged(sel);
        }
        if (this.selectedProjects != null) {
            BindProjectsWizard wizard = new BindProjectsWizard(this.selectedProjects);
            WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
            dialog.setHelpAvailable(true);
            dialog.open();
        }
    }
}

