/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.Server;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.server.actions.JobUtils;

public class UnbindProjectDialog
extends MessageDialog {
    protected List<ISonarLintProject> projects;

    public UnbindProjectDialog(Shell parentShell, List<ISonarLintProject> projects) {
        super(parentShell, Messages.unbindProjectDialogTitle, null, UnbindProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.projects = projects;
    }

    private static String getMessage(List<ISonarLintProject> projects) {
        StringBuilder sb = new StringBuilder();
        if (projects.size() == 1) {
            sb.append(NLS.bind((String)Messages.unbindProjectDialogMessage, (Object)projects.get(0).getName()));
        } else {
            sb.append(NLS.bind((String)Messages.unbindProjectDialogMessageMany, (Object)Integer.toString(projects.size())));
        }
        return sb.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && !this.projects.isEmpty()) {
            UnbindProjectJob job = new UnbindProjectJob();
            job.setPriority(40);
            job.schedule();
        }
        super.buttonPressed(buttonId);
    }

    private class UnbindProjectJob
    extends Job {
        UnbindProjectJob() {
            super(Messages.unbindProjectTask);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                for (ISonarLintProject project : UnbindProjectDialog.this.projects) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    String oldServerId = SonarLintProjectConfiguration.read((IScopeContext)project.getScopeContext()).getServerId();
                    Server.unbind((ISonarLintProject)project);
                    JobUtils.scheduleAnalysisOfOpenFiles(project, TriggerType.BINDING_CHANGE);
                    JobUtils.notifyServerViewAfterBindingChange(project, oldServerId);
                }
            }
            catch (Exception e) {
                return new Status(4, "org.sonarlint.eclipse.ui", 0, e.getMessage(), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

