/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.server;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;
import org.sonarlint.eclipse.ui.internal.server.BaseCellLabelProvider;

public class ServerLabelProvider
extends BaseCellLabelProvider {
    public String getText(Object element) {
        if (element instanceof IServer) {
            IServer server = (IServer)element;
            return StringUtils.defaultString((String)server.getId());
        }
        if (element instanceof ISonarLintProject) {
            return ((ISonarLintProject)element).getName();
        }
        if (element instanceof IWorkspaceRoot) {
            return Platform.getResourceString((Bundle)SonarLintUiPlugin.getDefault().getBundle(), (String)"%viewServers");
        }
        return "";
    }

    public Image getImage(Object element) {
        if (element instanceof IServer) {
            if (((IServer)element).isSonarCloud()) {
                return SonarLintImages.SONARCLOUD_SERVER_ICON_IMG;
            }
            return SonarLintImages.SONARQUBE_SERVER_ICON_IMG;
        }
        if (element instanceof ISonarLintProject) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
        return null;
    }

    @Override
    public Image getColumnImage(Object element, int index) {
        return null;
    }

    @Override
    public String getColumnText(Object element, int index) {
        return null;
    }
}

