/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.properties;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProperty;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;
import org.sonarlint.eclipse.ui.internal.properties.StatusInfo;

public class EditSonarPropertyDialog
extends StatusDialog {
    private SonarLintProperty sonarProperty;
    private Text fNameText;
    private Text fValueText;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private boolean fIsNameModifiable;

    public EditSonarPropertyDialog(Shell parent, SonarLintProperty property, boolean edit, boolean isNameModifiable) {
        super(parent);
        String title = edit ? "Edit property" : "New property";
        this.setTitle(title);
        this.sonarProperty = property;
        this.fIsNameModifiable = isNameModifiable;
        this.fValidationStatus = new StatusInfo();
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        this.updateStatusAndButtons();
        this.getButton(0).setEnabled(this.getStatus().isOK());
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        EditSonarPropertyDialog.createLabel(parent, "Name:");
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fNameText = this.createNameText(composite);
        if (this.fIsNameModifiable) {
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditSonarPropertyDialog.this.fSuppressError) {
                        EditSonarPropertyDialog.this.fSuppressError = false;
                        EditSonarPropertyDialog.this.updateStatusAndButtons();
                    }
                }
            });
        } else {
            this.fNameText.setEditable(false);
        }
        EditSonarPropertyDialog.createLabel(parent, "Value:");
        this.fValueText = new Text(parent, 2048);
        this.fValueText.setLayoutData((Object)new GridData(768));
        this.fValueText.setText(this.sonarProperty.getValue());
        this.fNameText.setText(this.sonarProperty.getName());
        if (this.fIsNameModifiable) {
            this.fNameText.addModifyListener(e -> {
                this.fSuppressError = false;
                this.updateStatusAndButtons();
            });
        }
        EditSonarPropertyDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private Text createNameText(Composite parent) {
        int descFlags = this.fIsNameModifiable ? 2048 : 2056;
        Text text = new Text(parent, descFlags);
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        text.setLayoutData((Object)gd);
        return text;
    }

    protected void okPressed() {
        String name = this.fNameText == null ? this.sonarProperty.getName() : this.fNameText.getText();
        this.sonarProperty = new SonarLintProperty(name, this.fValueText.getText());
        super.okPressed();
    }

    private void updateStatusAndButtons() {
        boolean isEmpty;
        StatusInfo status = this.fValidationStatus;
        boolean bl = isEmpty = this.fNameText != null && this.fNameText.getText().length() == 0;
        if (!this.fSuppressError && isEmpty) {
            status = new StatusInfo();
            status.setError("Please input a name");
        } else if (this.fNameText != null && !EditSonarPropertyDialog.isValidPropertyName(this.fNameText.getText())) {
            status = new StatusInfo();
            status.setError("Invalid property name");
        }
        this.updateStatus(status);
    }

    private static boolean isValidPropertyName(String name) {
        return !name.contains(" ");
    }

    public SonarLintProperty getSonarProperty() {
        return this.sonarProperty;
    }

    protected Point getInitialSize() {
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        Point restoredSize = super.getInitialSize();
        if (defaultSize.x > restoredSize.x) {
            restoredSize.x = defaultSize.x;
        }
        return restoredSize;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
        IDialogSettings settings = SonarLintUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }
}

