/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.properties;

import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;

public class AboutPropertyPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private Button enabledBtn;

    public AboutPropertyPage() {
        this.setTitle("Miscellaneous");
    }

    public void init(IWorkbench workbench) {
        this.setDescription("Statistics");
        this.setPreferenceStore(SonarLintUiPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        final Link text = new Link(composite, 0);
        GridData textGd = new GridData(4, 0x1000000, false, false, 2, 1);
        text.setLayoutData((Object)textGd);
        text.setText("By sharing anonymous SonarLint usage statistics, you help us understand how SonarLint is used so we can improve the plugin to work even better for you.\nWe don't collect source code, IP addresses, or any personally identifying information. And we don't share the data with anyone else.\n\nSee a <a href=\"#\">sample of the data.</a>");
        final DefaultToolTip tip = new DefaultToolTip((Control)text, 1, true);
        tip.setText("{\n    \"days_since_installation\": 120,\n    \"days_of_use\": 40,\n    \"sonarlint_version\": \"3.0.0\",\n    \"sonarlint_product\": \"SonarLint Eclipse\",\n    \"connected_mode_used\": true\n}");
        text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point cursorLocation = PlatformUI.getWorkbench().getDisplay().getCursorLocation();
                tip.show(PlatformUI.getWorkbench().getDisplay().map(null, (Control)text, cursorLocation.x, cursorLocation.y));
            }
        });
        this.enabledBtn = new Button(composite, 32);
        this.enabledBtn.setText("Share anonymous SonarLint statistics");
        this.enabledBtn.setSelection(SonarLintCorePlugin.getTelemetry().enabled());
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.enabledBtn.setLayoutData((Object)layoutData);
        return composite;
    }

    public boolean performOk() {
        SonarLintCorePlugin.getTelemetry().optOut(!this.enabledBtn.getSelection());
        return true;
    }

    protected void performDefaults() {
        this.enabledBtn.setSelection(true);
    }
}

