/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.popup;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.popup.AbstractNotificationPopup;
import org.sonarsource.sonarlint.core.client.api.notifications.SonarQubeNotification;

public class SonarQubeNotificationPopup
extends AbstractNotificationPopup {
    private final SonarQubeNotification notification;

    public SonarQubeNotificationPopup(Display display, SonarQubeNotification notification) {
        super(display);
        this.notification = notification;
    }

    @Override
    protected void createContentArea(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, true));
        Label messageLabel = new Label(composite, 64);
        GridData layoutData = new GridData(768);
        messageLabel.setLayoutData((Object)layoutData);
        messageLabel.setText(this.notification.message());
        messageLabel.setBackground(composite.getBackground());
        Composite links = new Composite(composite, 0);
        links.setLayoutData((Object)new GridData(128));
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 20;
        links.setLayout((Layout)rowLayout);
        Link detailsLink = new Link(links, 0);
        detailsLink.setText("<a>Check it here</a>");
        detailsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SonarQubeNotificationPopup.this.close();
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(SonarQubeNotificationPopup.this.notification.link()));
                }
                catch (MalformedURLException | PartInitException throwable) {}
            }
        });
    }

    @Override
    protected String getPopupShellTitle() {
        return "SonarQube event";
    }

    @Override
    protected Image getPopupShellImage(int maximumHeight) {
        return SonarLintImages.BALLOON_IMG;
    }
}

