/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.popup;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.ServerUpdateJob;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.popup.AbstractNotificationPopup;
import org.sonarlint.eclipse.ui.internal.server.actions.JobUtils;

public class ServerUpdateAvailablePopup
extends AbstractNotificationPopup {
    private final IServer server;

    public ServerUpdateAvailablePopup(Display display, IServer server) {
        super(display);
        this.server = server;
    }

    @Override
    protected void createContentArea(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, true));
        Label messageLabel = new Label(composite, 64);
        GridData layoutData = new GridData(768);
        messageLabel.setLayoutData((Object)layoutData);
        messageLabel.setText("Updates are available on SonarQube server '" + this.server.getId() + "'.\nDo you want to download and update them now?");
        messageLabel.setBackground(composite.getBackground());
        Composite links = new Composite(composite, 0);
        links.setLayoutData((Object)new GridData(128));
        RowLayout rowLayout = new RowLayout();
        rowLayout.spacing = 20;
        links.setLayout((Layout)rowLayout);
        Link detailsLink = new Link(links, 0);
        detailsLink.setText("<a>Remind me later</a>");
        detailsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerUpdateAvailablePopup.this.close();
            }
        });
        Link updateLink = new Link(links, 0);
        updateLink.setText("<a>Update now</a>");
        updateLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerUpdateAvailablePopup.this.close();
                ServerUpdateJob job = new ServerUpdateJob(ServerUpdateAvailablePopup.this.server);
                JobUtils.scheduleAnalysisOfOpenFilesInBoundProjects((Job)job, ServerUpdateAvailablePopup.this.server, TriggerType.BINDING_CHANGE);
                job.schedule();
            }
        });
    }

    @Override
    protected String getPopupShellTitle() {
        return "Updates for SonarLint";
    }

    @Override
    protected Image getPopupShellImage(int maximumHeight) {
        return SonarLintImages.BALLOON_IMG;
    }
}

