/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.popup;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.ServerUpdateJob;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.popup.AbstractNotificationPopup;
import org.sonarlint.eclipse.ui.internal.server.actions.JobUtils;

public class ServerStorageNeedUpdatePopup
extends AbstractNotificationPopup {
    private final IServer server;

    public ServerStorageNeedUpdatePopup(Display display, IServer server) {
        super(display);
        this.server = server;
        this.setDelayClose(0L);
    }

    @Override
    protected void createContentArea(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, true));
        Label messageLabel = new Label(composite, 64);
        messageLabel.setLayoutData((Object)new GridData(768));
        messageLabel.setText("Configuration stored from SonarQube server '" + this.server.getId() + "' is missing or outdated.");
        messageLabel.setBackground(composite.getBackground());
        Link updateServerLink = new Link(composite, 0);
        updateServerLink.setText("<a>Update all project bindings from '" + this.server.getId() + "'</a>");
        updateServerLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerUpdateJob job = new ServerUpdateJob(ServerStorageNeedUpdatePopup.this.server);
                JobUtils.scheduleAnalysisOfOpenFilesInBoundProjects((Job)job, ServerStorageNeedUpdatePopup.this.server, TriggerType.BINDING_CHANGE);
                job.schedule();
                ServerStorageNeedUpdatePopup.this.close();
            }
        });
    }

    @Override
    protected String getPopupShellTitle() {
        return "SonarLint stored configuration outdated";
    }

    @Override
    protected Image getPopupShellImage(int maximumHeight) {
        return SonarLintImages.BALLOON_IMG;
    }
}

