/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.popup;

import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GradientColors {
    private final Display display;
    private Color titleText;
    private Color gradientBegin;
    private Color gradientEnd;
    private Color border;
    private final ResourceManager resourceManager;

    public GradientColors(Display display, ResourceManager resourceManager) {
        this.display = display;
        this.resourceManager = resourceManager;
        this.createColors();
    }

    private void createColors() {
        this.createBorderColor();
        this.createGradientColors();
        this.titleText = GradientColors.getColor(this.resourceManager, this.getSystemColor(17));
    }

    public Color getGradientBegin() {
        return this.gradientBegin;
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public Color getBorder() {
        return this.border;
    }

    public Color getTitleText() {
        return this.titleText;
    }

    private void createBorderColor() {
        RGB tbBorder = this.getSystemColor(31);
        RGB bg = this.getBackground();
        tbBorder = GradientColors.testTwoPrimaryColors(tbBorder, 179, 256) ? GradientColors.blend(tbBorder, bg, 70) : (GradientColors.testTwoPrimaryColors(tbBorder, 120, 180) ? GradientColors.blend(tbBorder, bg, 50) : GradientColors.blend(tbBorder, bg, 30));
        this.border = GradientColors.getColor(this.resourceManager, tbBorder);
    }

    private void createGradientColors() {
        RGB top;
        RGB bottom;
        RGB titleBg = this.getSystemColor(31);
        RGB bg = this.getBackground();
        if (GradientColors.testTwoPrimaryColors(titleBg, 179, 256)) {
            bottom = GradientColors.blend(titleBg, bg, 30);
            top = bg;
        } else if (GradientColors.testTwoPrimaryColors(titleBg, 120, 180)) {
            bottom = GradientColors.blend(titleBg, bg, 20);
            top = bg;
        } else {
            bottom = GradientColors.blend(titleBg, bg, 10);
            top = bg;
        }
        this.gradientBegin = GradientColors.getColor(this.resourceManager, top);
        this.gradientEnd = GradientColors.getColor(this.resourceManager, bottom);
    }

    private static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = GradientColors.blend(c1.red, c2.red, ratio);
        int g = GradientColors.blend(c1.green, c2.green, ratio);
        int b = GradientColors.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private static int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    private static boolean testTwoPrimaryColors(RGB rgb, int from, int to) {
        int total = 0;
        if (GradientColors.testPrimaryColor(rgb.red, from, to)) {
            ++total;
        }
        if (GradientColors.testPrimaryColor(rgb.green, from, to)) {
            ++total;
        }
        if (GradientColors.testPrimaryColor(rgb.blue, from, to)) {
            ++total;
        }
        return total >= 2;
    }

    private static boolean testPrimaryColor(int value, int from, int to) {
        return value > from && value < to;
    }

    private RGB getSystemColor(int code) {
        return this.getDisplay().getSystemColor(code).getRGB();
    }

    private Color getImpliedBackground() {
        return this.display.getSystemColor(25);
    }

    private Display getDisplay() {
        return this.display;
    }

    private static Color getColor(ResourceManager manager, RGB rgb) {
        try {
            return manager.createColor(rgb);
        }
        catch (DeviceResourceException deviceResourceException) {
            return manager.getDevice().getSystemColor(2);
        }
    }

    private RGB getBackground() {
        return this.getImpliedBackground().getRGB();
    }
}

