/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.views.RuleDescriptionWebView;

public class ShowRuleDescriptionMarkerResolver
implements IMarkerResolution2 {
    private final IMarker marker;

    public ShowRuleDescriptionMarkerResolver(IMarker marker) {
        this.marker = marker;
    }

    public String getDescription() {
        return "Open rule description to better understand the issue: " + this.marker.getAttribute("message", "unknown");
    }

    public String getLabel() {
        return "Open description of rule " + this.marker.getAttribute("rulekey", "unknown");
    }

    public void run(IMarker marker) {
        try {
            RuleDescriptionWebView view = (RuleDescriptionWebView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.sonarlint.eclipse.ui.views.RuleDescriptionWebView");
            view.setInput(marker);
        }
        catch (Exception e) {
            SonarLintLogger.get().error("Unable to open rule description view", (Throwable)e);
        }
    }

    public Image getImage() {
        return SonarLintImages.IMG_ISSUE;
    }
}

