/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.Server;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.SonarLintProjectDecorator;
import org.sonarlint.eclipse.ui.internal.server.actions.JobUtils;

public class UnbindProjectsCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        final ArrayList<ISonarLintProject> selectedProjects = new ArrayList<ISonarLintProject>();
        List elems = selection.toList();
        for (Object elem : elems) {
            ISonarLintProject proj = (ISonarLintProject)Adapters.adapt(elem, ISonarLintProject.class);
            if (proj == null) continue;
            selectedProjects.add(proj);
        }
        Job job = new Job("Unbind projects"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Unbind projects", selectedProjects.size());
                for (ISonarLintProject p : selectedProjects) {
                    SonarLintProjectConfiguration projectConfig = SonarLintProjectConfiguration.read((IScopeContext)p.getScopeContext());
                    String oldServerId = projectConfig.getServerId();
                    Server.unbind((ISonarLintProject)p);
                    JobUtils.scheduleAnalysisOfOpenFiles(p, TriggerType.BINDING_CHANGE);
                    JobUtils.notifyServerViewAfterBindingChange(p, oldServerId);
                    monitor.worked(1);
                }
                IBaseLabelProvider labelProvider = PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider("org.sonarlint.eclipse.ui.sonarlintDecorator");
                if (labelProvider != null) {
                    ((SonarLintProjectDecorator)labelProvider).fireChange(selectedProjects);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return null;
    }
}

