/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.bind.BindProjectsWizard;

public class BindProjectsCommand
extends AbstractHandler {
    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        ArrayList<ISonarLintProject> selectedProjects = new ArrayList<ISonarLintProject>();
        List elems = selection.toList();
        for (Object elem : elems) {
            ISonarLintProject proj = (ISonarLintProject)Adapters.adapt(elem, ISonarLintProject.class);
            if (proj == null) continue;
            selectedProjects.add(proj);
        }
        BindProjectsWizard wizard = new BindProjectsWizard(selectedProjects);
        Display display = BindProjectsCommand.getDisplay();
        WizardDialog dialog = new WizardDialog(display.getActiveShell(), (IWizard)wizard);
        dialog.setHelpAvailable(true);
        BusyIndicator.showWhile((Display)display, () -> ((WizardDialog)dialog).open());
        return null;
    }
}

