/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectsJob;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.command.AnalyzeChangeSetCommand;
import org.sonarlint.eclipse.ui.internal.util.PlatformUtils;
import org.sonarlint.eclipse.ui.internal.util.SelectionUtils;

public class AnalyzeCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Map<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>> filesPerProject;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            filesPerProject = this.findSelectedFilesPerProject(event);
        } else {
            filesPerProject = new HashMap<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>>(1);
            AnalyzeProjectRequest.FileWithDocument editedFile = AnalyzeCommand.findEditedFile(event);
            if (editedFile != null) {
                filesPerProject.put(editedFile.getFile().getProject(), Arrays.asList(editedFile));
            }
        }
        if (!filesPerProject.isEmpty()) {
            AnalyzeCommand.runAnalysisJob(HandlerUtil.getActiveShell((ExecutionEvent)event), filesPerProject);
        }
        return null;
    }

    private static void runAnalysisJob(Shell shell, Map<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>> filesPerProject) {
        Map.Entry<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>> entry;
        int fileCount;
        AnalyzeProjectsJob job = new AnalyzeProjectsJob(filesPerProject);
        int totalFileCount = filesPerProject.values().stream().mapToInt(Collection::size).sum();
        if (totalFileCount > 1 && !AnalyzeCommand.askConfirmation(shell)) {
            return;
        }
        String reportTitle = filesPerProject.size() == 1 ? ((fileCount = (entry = filesPerProject.entrySet().iterator().next()).getValue().size()) > 1 ? String.valueOf(fileCount) + " files of project " + entry.getKey().getName() : "File " + entry.getValue().iterator().next().getFile().getName()) : "All files of " + filesPerProject.size() + " projects";
        AnalyzeChangeSetCommand.registerJobListener((Job)job, reportTitle);
        job.schedule();
    }

    private static boolean askConfirmation(Shell shell) {
        MessageDialog dialog = new MessageDialog(shell, "Confirmation", null, "Analyzing multiple files may take a long time to complete.\nTo get the best from SonarLint, you should preferably use the on-the-fly analysis for the files you're working on.", 5, new String[]{"Proceed", IDialogConstants.CANCEL_LABEL}, 0);
        return dialog.open() == 0;
    }

    protected Map<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>> findSelectedFilesPerProject(ExecutionEvent event) throws ExecutionException {
        LinkedHashMap<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>> filesToAnalyzePerProject = new LinkedHashMap<ISonarLintProject, Collection<AnalyzeProjectRequest.FileWithDocument>>();
        for (ISonarLintFile file : SelectionUtils.allSelectedFiles(HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event))) {
            filesToAnalyzePerProject.putIfAbsent(file.getProject(), new ArrayList());
            IEditorPart editorPart = PlatformUtils.findEditor(file);
            if (editorPart instanceof ITextEditor) {
                IDocument doc = ((ITextEditor)editorPart).getDocumentProvider().getDocument((Object)editorPart.getEditorInput());
                ((Collection)filesToAnalyzePerProject.get(file.getProject())).add(new AnalyzeProjectRequest.FileWithDocument(file, doc));
                continue;
            }
            ((Collection)filesToAnalyzePerProject.get(file.getProject())).add(new AnalyzeProjectRequest.FileWithDocument(file, null));
        }
        return filesToAnalyzePerProject;
    }

    static AnalyzeProjectRequest.FileWithDocument findEditedFile(ExecutionEvent event) {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor == null) {
            return null;
        }
        IEditorInput input = activeEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IDocument doc = ((ITextEditor)activeEditor).getDocumentProvider().getDocument((Object)activeEditor.getEditorInput());
            IFile file = ((IFileEditorInput)input).getFile();
            ISonarLintFile sonarLintFile = (ISonarLintFile)Adapters.adapt((Object)file, ISonarLintFile.class);
            return sonarLintFile != null ? new AnalyzeProjectRequest.FileWithDocument(sonarLintFile, doc) : null;
        }
        return null;
    }
}

