/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.command;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeChangedFilesJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.command.AnalyzeCommand;
import org.sonarlint.eclipse.ui.internal.util.SelectionUtils;
import org.sonarlint.eclipse.ui.internal.views.issues.SonarLintReportView;

public class AnalyzeChangeSetCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        AnalyzeProjectRequest.FileWithDocument editedFile;
        Collection<ISonarLintProject> selectedProjects = SelectionUtils.allSelectedProjects(event);
        if (selectedProjects.isEmpty() && (editedFile = AnalyzeCommand.findEditedFile(event)) != null) {
            selectedProjects = Arrays.asList(editedFile.getFile().getProject());
        }
        if (!selectedProjects.isEmpty()) {
            AnalyzeChangeSetCommand.triggerAnalysis(selectedProjects);
        }
        return null;
    }

    private static void triggerAnalysis(Collection<ISonarLintProject> selectedProjects) {
        AnalyzeChangedFilesJob job = new AnalyzeChangedFilesJob(selectedProjects);
        String reportTitle = selectedProjects.size() == 1 ? "Changed files reported by the SCM on project " + selectedProjects.iterator().next().getName() : "Changed files reported by the SCM on " + selectedProjects.size() + " projects";
        AnalyzeChangeSetCommand.registerJobListener((Job)job, reportTitle);
        job.schedule();
    }

    static void registerJobListener(Job job, final String reportTitle) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (Status.OK_STATUS == event.getResult()) {
                    Display.getDefault().asyncExec(() -> {
                        IWorkbenchWindow iw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            iw.getActivePage().showView("org.sonarlint.eclipse.ui.views.issues.ChangeSetIssuesView", null, 1);
                            SonarLintReportView.setReportTitle(reportTitle);
                        }
                        catch (PartInitException e) {
                            SonarLintLogger.get().error("Unable to open SonarLint Report View", (Throwable)e);
                        }
                    });
                } else if (Status.CANCEL_STATUS == event.getResult()) {
                    Display.getDefault().asyncExec(() -> SonarLintReportView.setReportTitle(null));
                } else {
                    Display.getDefault().asyncExec(() -> {
                        IWorkbenchWindow iw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            iw.getActivePage().showView("org.sonarlint.eclipse.ui.views.issues.ChangeSetIssuesView", null, 1);
                            SonarLintReportView.setReportTitle(event.getResult().getMessage());
                        }
                        catch (PartInitException e) {
                            SonarLintLogger.get().error("Unable to open SonarLint Report View", (Throwable)e);
                        }
                    });
                }
            }
        });
    }
}

