/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.bind;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.ui.internal.bind.RemoteSonarProject;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;

public class SearchEngineProvider
implements IContentProposalProvider {
    private final WizardPage parentPage;
    private final IServer server;
    private TextSearchIndex<RemoteModule> moduleIndex;

    public SearchEngineProvider(IServer server, WizardPage parentPage) {
        this.server = server;
        this.parentPage = parentPage;
    }

    public TextSearchIndex<RemoteModule> getModuleIndex() {
        if (this.moduleIndex == null && this.server.isStorageUpdated()) {
            this.moduleIndex = this.server.getModuleIndex();
        }
        return this.moduleIndex;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (!this.server.isStorageUpdated()) {
            this.parentPage.setMessage("Please refresh project list from server first", 1);
            return new IContentProposal[0];
        }
        ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
        try {
            Map modules = this.getModuleIndex().search(contents);
            ArrayList entries = new ArrayList(modules.entrySet());
            entries.sort(Comparator.comparing(Map.Entry::getValue).reversed().thenComparing(Comparator.comparing(e -> ((RemoteModule)e.getKey()).getName(), String.CASE_INSENSITIVE_ORDER)));
            for (Map.Entry entry : entries) {
                RemoteModule module = (RemoteModule)entry.getKey();
                RemoteSonarProject prj = new RemoteSonarProject(this.server.getId(), module.getProjectKey(), module.getKey(), module.getName());
                list.add(new ContentProposal(prj.asString(), ((RemoteModule)entry.getKey()).getName(), prj.getDescription()));
            }
        }
        catch (Exception e3) {
            SonarLintLogger.get().debug("Unable to search modules from server " + this.server.getId(), (Throwable)e3);
        }
        if (!list.isEmpty()) {
            this.parentPage.setMessage("", 0);
            return list.toArray(new IContentProposal[list.size()]);
        }
        this.parentPage.setMessage("No results", 1);
        return new IContentProposal[0];
    }
}

