/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.bind;

import org.eclipse.core.runtime.preferences.IScopeContext;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.bind.AbstractModelObject;

public class ProjectBindModel
extends AbstractModelObject {
    public static final String PROPERTY_PROJECT_ECLIPSE_NAME = "eclipseName";
    public static final String PROPERTY_PROJECT_SONAR_FULLNAME = "displayName";
    private final ISonarLintProject project;
    private String projectKey;
    private String moduleKey;
    private String serverId;
    private IServer server;
    private boolean autoBindFailed;

    public ProjectBindModel(ISonarLintProject project) {
        this.project = project;
        SonarLintProjectConfiguration projectConfig = SonarLintProjectConfiguration.read((IScopeContext)project.getScopeContext());
        this.projectKey = projectConfig.getProjectKey();
        this.moduleKey = projectConfig.getModuleKey();
        this.serverId = projectConfig.getServerId();
        this.server = SonarLintCorePlugin.getServersManager().getServer(this.serverId);
    }

    public ISonarLintProject getProject() {
        return this.project;
    }

    public String getEclipseName() {
        return this.project.getName();
    }

    public String getDisplayName() {
        if (StringUtils.isBlank((String)this.moduleKey)) {
            if (this.autoBindFailed) {
                return "<Auto-bind failed. Type here to start searching for a remote SonarQube project...>";
            }
            return "<Type here to start searching for a remote SonarQube project...>";
        }
        if (this.server == null) {
            return "<Bound to an unknown server: '" + this.serverId + "'>";
        }
        return String.format("'%s' on server '%s'", this.moduleKey, this.server.getId());
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getModuleKey() {
        return this.moduleKey;
    }

    public void associate(String serverId, String projectKey, String moduleKey) {
        String oldValue = this.getDisplayName();
        this.autoBindFailed = false;
        this.projectKey = projectKey;
        this.moduleKey = moduleKey;
        this.serverId = serverId;
        this.server = SonarLintCorePlugin.getServersManager().getServer(this.serverId);
        this.firePropertyChange(PROPERTY_PROJECT_SONAR_FULLNAME, oldValue, this.getDisplayName());
    }

    public void unassociate() {
        String oldValue = this.getDisplayName();
        this.autoBindFailed = false;
        this.resetBinding();
        this.firePropertyChange(PROPERTY_PROJECT_SONAR_FULLNAME, oldValue, this.getDisplayName());
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setAutoBindFailed(boolean autoBindFailed) {
        String oldValue = this.getDisplayName();
        this.autoBindFailed = autoBindFailed;
        this.resetBinding();
        this.firePropertyChange(PROPERTY_PROJECT_SONAR_FULLNAME, oldValue, this.getDisplayName());
    }

    private void resetBinding() {
        this.projectKey = null;
        this.moduleKey = null;
        this.serverId = null;
        this.server = null;
    }
}

