/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal.bind;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.ProjectUpdateJob;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.IServerLifecycleListener;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.ui.internal.Messages;
import org.sonarlint.eclipse.ui.internal.SonarLintImages;
import org.sonarlint.eclipse.ui.internal.SonarLintUiPlugin;
import org.sonarlint.eclipse.ui.internal.bind.ProjectBindModel;
import org.sonarlint.eclipse.ui.internal.bind.SearchEngineProvider;
import org.sonarlint.eclipse.ui.internal.bind.TextCellEditorWithContentProposal;
import org.sonarlint.eclipse.ui.internal.server.actions.JobUtils;
import org.sonarlint.eclipse.ui.internal.server.wizard.ServerConnectionWizard;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;

public class BindProjectsPage
extends WizardPage {
    private final List<ISonarLintProject> projects;
    private CheckboxTableViewer viewer;
    private Form noServersPage;
    private PageBook book;
    private IServerLifecycleListener serverListener;
    private IServer selectedServer;
    private Composite serverDropDownPage;
    private ComboViewer serverCombo;
    private Button autoBindBtn;
    private Button unassociateBtn;
    private Button checkAll;
    private Composite container;
    private Link updateServerLink;

    public BindProjectsPage(List<ISonarLintProject> projects) {
        super("bindProjects", "Bind Eclipse projects to SonarQube projects", SonarLintImages.SONARWIZBAN_IMG);
        this.setDescription("SonarQube is an Open Source platform to manage code quality. Bind your Eclipse projects to some SonarQube projects in order to get the same issues in Eclipse and in SonarQube.");
        this.projects = projects;
        if (!projects.isEmpty()) {
            this.selectedServer = SonarLintCorePlugin.getServersManager().getServer(SonarLintProjectConfiguration.read((IScopeContext)projects.get(0).getScopeContext()).getServerId());
        }
    }

    public void dispose() {
        if (this.serverListener != null) {
            SonarLintCorePlugin.getServersManager().removeServerLifecycleListener(this.serverListener);
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        this.container.setLayout((Layout)layout);
        this.book = new PageBook(this.container, 0);
        this.createNoServerForm((Composite)this.book);
        this.createServerDropDown((Composite)this.book);
        this.toggleServerPage();
        this.createCheckUncheckAllCb();
        this.viewer = CheckboxTableViewer.newCheckList((Composite)this.container, (int)68352);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        this.viewer.getTable().setHeaderVisible(true);
        TableViewerColumn columnProject = new TableViewerColumn((TableViewer)this.viewer, 16384);
        columnProject.getColumn().setText("Eclipse Project");
        columnProject.getColumn().setWidth(200);
        TableViewerColumn columnSonarProject = new TableViewerColumn((TableViewer)this.viewer, 16384);
        columnSonarProject.getColumn().setText("SonarQube Project");
        columnSonarProject.getColumn().setWidth(600);
        columnSonarProject.setEditingSupport((EditingSupport)new ProjectAssociationModelEditingSupport((TableViewer)this.viewer));
        ArrayList<ProjectBindModel> list = new ArrayList<ProjectBindModel>();
        for (ISonarLintProject project : this.projects) {
            ProjectBindModel sonarProject = new ProjectBindModel(project);
            list.add(sonarProject);
        }
        ColumnViewerEditorActivationStrategy activationSupport = this.createActivationSupport();
        FocusCellOwnerDrawHighlighter focusCellHighlighter = new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager((TableViewer)this.viewer, (FocusCellHighlighter)focusCellHighlighter);
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)activationSupport, (int)40);
        ViewerSupport.bind((StructuredViewer)this.viewer, (IObservableList)new WritableList(list, ProjectBindModel.class), (IValueProperty[])new IValueProperty[]{BeanProperties.value(ProjectBindModel.class, (String)"eclipseName"), BeanProperties.value(ProjectBindModel.class, (String)"displayName")});
        Composite btnContainer = new Composite(this.container, 0);
        FillLayout btnLayout = new FillLayout();
        btnContainer.setLayout((Layout)btnLayout);
        this.viewer.addSelectionChangedListener(event -> this.updateState());
        this.createUnassociateBtn(btnContainer);
        this.createAutoBindBtn(btnContainer);
        this.viewer.setAllChecked(true);
        this.updateState();
        this.setControl((Control)this.container);
    }

    private void createAutoBindBtn(Composite btnContainer) {
        this.autoBindBtn = new Button(btnContainer, 8);
        this.autoBindBtn.setText("Auto bind selected projects");
        this.autoBindBtn.addListener(13, event -> {
            TextSearchIndex moduleIndex = this.selectedServer.getModuleIndex();
            Object[] objectArray = this.viewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ProjectBindModel bind = (ProjectBindModel)object;
                Map results = moduleIndex.search(bind.getEclipseName());
                if (!results.isEmpty()) {
                    RemoteModule remoteModule = (RemoteModule)results.keySet().iterator().next();
                    bind.associate(this.selectedServer.getId(), remoteModule.getProjectKey(), remoteModule.getKey());
                } else {
                    bind.setAutoBindFailed(true);
                }
                ++n2;
            }
        });
    }

    private void createUnassociateBtn(Composite btnContainer) {
        this.unassociateBtn = new Button(btnContainer, 8);
        this.unassociateBtn.setText("Unbind selected projects");
        this.unassociateBtn.setEnabled(this.viewer.getCheckedElements().length > 0);
        this.unassociateBtn.addListener(13, event -> {
            Object[] objectArray = this.viewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                ProjectBindModel bind = (ProjectBindModel)object;
                bind.unassociate();
                ++n2;
            }
        });
    }

    private void createCheckUncheckAllCb() {
        this.checkAll = new Button(this.container, 32);
        this.checkAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindProjectsPage.this.viewer.setAllChecked(BindProjectsPage.this.checkAll.getSelection());
                BindProjectsPage.this.updateState();
            }
        });
    }

    private void createServerDropDown(Composite parent) {
        this.serverDropDownPage = new Composite(parent, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.serverDropDownPage.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        this.serverDropDownPage.setLayout((Layout)layout);
        Label labelField = new Label(this.serverDropDownPage, 0);
        labelField.setText("Select a SonarQube server: ");
        this.serverCombo = new ComboViewer(this.serverDropDownPage, 8);
        this.serverCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.serverCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IServer current = (IServer)element;
                return current.getId();
            }
        });
        this.updateServerLink = new Link(this.serverDropDownPage, 0);
        this.updateServerLink.setText("<a>Refresh project list</a>");
        this.updateServerLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindProjectsPage.this.updateProjectListOfSelectedServer();
            }
        });
        this.serverListener = new ServerChangeListener();
        SonarLintCorePlugin.getServersManager().addServerLifecycleListener(this.serverListener);
        this.serverCombo.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.selectedServer = (IServer)selection.getFirstElement();
            this.serverCombo.refresh();
            this.updateState();
        });
    }

    /*
     * Exception decompiling
     */
    private void updateProjectListOfSelectedServer() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateState() {
        if (this.viewer == null) {
            return;
        }
        this.updateServerLink.setVisible(this.selectedServer != null);
        this.updateServerLink.setEnabled(this.selectedServer != null && !this.selectedServer.isUpdating());
        boolean hasSelected = this.viewer.getCheckedElements().length > 0;
        this.checkAll.setSelection(hasSelected);
        this.checkAll.setGrayed(this.viewer.getCheckedElements().length < this.projects.size());
        this.checkAll.setText(hasSelected ? "Unselect all" : "Select all");
        this.unassociateBtn.setEnabled(hasSelected);
        if (this.selectedServer != null && !this.selectedServer.isStorageUpdated()) {
            this.setMessage("No data for the selected server", 2);
        } else {
            this.setMessage(null);
        }
        if (this.autoBindBtn != null) {
            this.autoBindBtn.setEnabled(hasSelected && this.selectedServer != null && this.selectedServer.isStorageUpdated());
        }
        this.container.layout(true, true);
    }

    private void createNoServerForm(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.noServersPage = toolkit.createForm((Composite)this.book);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.noServersPage.setLayoutData((Object)layoutData);
        Composite body = this.noServersPage.getBody();
        GridLayout layout = new GridLayout(2, false);
        body.setLayout((Layout)layout);
        Link hlink = new Link(body, 0);
        hlink.setText(Messages.ServersView_noServers);
        hlink.setBackground(this.book.getDisplay().getSystemColor(25));
        GridData gd = new GridData(16384, 4, true, false);
        hlink.setLayoutData((Object)gd);
        hlink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardDialog wd = ServerConnectionWizard.createDialog(BindProjectsPage.this.book.getShell());
                if (wd.open() == 0) {
                    BindProjectsPage.this.toggleServerPage();
                }
            }
        });
    }

    private void toggleServerPage() {
        List servers = SonarLintCorePlugin.getServersManager().getServers();
        if (servers.isEmpty()) {
            this.book.showPage((Control)this.noServersPage);
            this.selectedServer = null;
        } else {
            this.book.showPage((Control)this.serverDropDownPage);
            this.serverCombo.setInput((Object)servers.toArray());
            if (!servers.contains(this.selectedServer)) {
                this.selectedServer = (IServer)servers.get(0);
            }
            this.serverCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedServer));
        }
    }

    private ColumnViewerEditorActivationStrategy createActivationSupport() {
        ColumnViewerEditorActivationStrategy activationSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 4 || event.eventType == 1 && event.keyCode == KeyLookupFactory.getDefault().formalKeyLookup("F2");
            }
        };
        activationSupport.setEnableEditorActivationWithKeyboard(true);
        return activationSupport;
    }

    public boolean finish() {
        ProjectBindModel[] projectBindings;
        ProjectBindModel[] projectBindModelArray = projectBindings = this.getProjects();
        int n = projectBindings.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectBindModel projectBinding = projectBindModelArray[n2];
            BindProjectsPage.updateProjectBinding(projectBinding);
            ++n2;
        }
        return true;
    }

    private static void updateProjectBinding(ProjectBindModel projectBinding) {
        boolean changed = false;
        ISonarLintProject project = projectBinding.getProject();
        SonarLintProjectConfiguration projectConfig = SonarLintProjectConfiguration.read((IScopeContext)project.getScopeContext());
        String oldServerId = projectConfig.getServerId();
        if (!Objects.equals(projectBinding.getServerId(), oldServerId)) {
            projectConfig.setServerId(projectBinding.getServerId());
            changed = true;
        }
        if (!Objects.equals(projectBinding.getProjectKey(), projectConfig.getProjectKey())) {
            projectConfig.setProjectKey(projectBinding.getProjectKey());
            changed = true;
        }
        if (!Objects.equals(projectBinding.getModuleKey(), projectConfig.getModuleKey())) {
            projectConfig.setModuleKey(projectBinding.getModuleKey());
            changed = true;
        }
        if (changed) {
            SonarLintUiPlugin.unsubscribeToNotifications(project);
            projectConfig.save();
            BindProjectsPage.updateProjectBinding(project, oldServerId);
        }
    }

    private static void updateProjectBinding(ISonarLintProject project, String oldServerId) {
        project.deleteAllMarkers("org.sonarlint.eclipse.core.sonarlintOnTheFlyProblem");
        project.deleteAllMarkers("org.sonarlint.eclipse.core.sonarlintReportProblem");
        SonarLintCorePlugin.clearIssueTracker((ISonarLintProject)project);
        JobUtils.scheduleAnalysisOfOpenFiles(project, TriggerType.BINDING_CHANGE);
        if (project.isBound()) {
            new ProjectUpdateJob(project).schedule();
            SonarLintUiPlugin.subscribeToNotifications(project);
        }
        JobUtils.notifyServerViewAfterBindingChange(project, oldServerId);
    }

    private ProjectBindModel[] getProjects() {
        WritableList projectAssociations = (WritableList)this.viewer.getInput();
        return (ProjectBindModel[])projectAssociations.toArray((Object[])new ProjectBindModel[projectAssociations.size()]);
    }

    private /* synthetic */ void lambda$4(IServer iServer, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        iServer.updateModuleList(monitor);
        Display.getDefault().asyncExec(this::updateState);
    }

    private class ProjectAssociationModelEditingSupport
    extends EditingSupport {
        public ProjectAssociationModelEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
        }

        protected boolean canEdit(Object element) {
            return BindProjectsPage.this.selectedServer != null && element instanceof ProjectBindModel;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditorWithContentProposal((Composite)BindProjectsPage.this.viewer.getTable(), new SearchEngineProvider(BindProjectsPage.this.selectedServer, BindProjectsPage.this), (ProjectBindModel)element);
        }

        protected Object getValue(Object element) {
            return StringUtils.trimToEmpty((String)((ProjectBindModel)element).getDisplayName());
        }

        protected void setValue(Object element, Object value) {
        }
    }

    private final class ServerChangeListener
    implements IServerLifecycleListener {
        private ServerChangeListener() {
        }

        public void serverRemoved(IServer server) {
            this.updateServerPage();
        }

        public void serverChanged(IServer server) {
            this.updateServerPage();
        }

        public void serverAdded(IServer server) {
            this.updateServerPage();
        }

        private void updateServerPage() {
            BindProjectsPage.this.getContainer().getShell().getDisplay().asyncExec(() -> {
                BindProjectsPage.this.toggleServerPage();
                BindProjectsPage.this.getContainer().getShell().layout(true, true);
            });
        }
    }
}

