/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.ui.internal;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.texteditor.ITextEditor;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;

public class SonarLintPartListener
implements IPartListener2 {
    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(true);
        if (part instanceof IEditorPart) {
            IFile file;
            ISonarLintFile sonarLintFile;
            IEditorPart editorPart = (IEditorPart)part;
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            if (input instanceof IFileEditorInput && (sonarLintFile = (ISonarLintFile)Adapters.adapt((Object)(file = ((IFileEditorInput)input).getFile()), ISonarLintFile.class)) != null) {
                SonarLintPartListener.scheduleUpdate(editorPart, sonarLintFile);
            }
        }
    }

    private static void scheduleUpdate(IEditorPart editorPart, ISonarLintFile sonarLintFile) {
        if (editorPart instanceof ITextEditor) {
            IDocument doc = ((ITextEditor)editorPart).getDocumentProvider().getDocument((Object)editorPart.getEditorInput());
            SonarLintPartListener.scheduleUpdate(new AnalyzeProjectRequest.FileWithDocument(sonarLintFile, doc));
        } else {
            SonarLintPartListener.scheduleUpdate(new AnalyzeProjectRequest.FileWithDocument(sonarLintFile, null));
        }
    }

    private static void scheduleUpdate(AnalyzeProjectRequest.FileWithDocument fileWithDoc) {
        ISonarLintFile file = fileWithDoc.getFile();
        if (!file.getProject().isAutoEnabled()) {
            return;
        }
        AnalyzeProjectRequest request = new AnalyzeProjectRequest(file.getProject(), Arrays.asList(fileWithDoc), TriggerType.EDITOR_OPEN);
        new AnalyzeProjectJob(request).schedule();
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }
}

