/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeanReferenceSearchRequestor;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class BeansCompletionUtils {
    public static void addBeanReferenceProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder, boolean showExternal) {
        BeansCompletionUtils.addBeanReferenceProposals(context, recorder, showExternal, new ArrayList<String>());
    }

    public static void addBeanReferenceProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder, boolean showExternal, List<String> requiredTypes) {
        String prefix = context.getMatchString();
        IFile file = context.getFile();
        Document document = context.getDocument();
        if (prefix == null) {
            prefix = "";
        }
        if (document != null) {
            BeanReferenceSearchRequestor requestor = new BeanReferenceSearchRequestor(recorder, requiredTypes);
            Map<String, Node> beanNodes = BeansEditorUtils.getReferenceableNodes(document, context.getFile());
            for (Map.Entry<String, Node> node : beanNodes.entrySet()) {
                Node beanNode = node.getValue();
                requestor.acceptSearchMatch(node.getKey(), beanNode, file, prefix);
            }
            if (showExternal) {
                Set<IBean> beansList = BeansEditorUtils.getBeansFromConfigSets(file);
                for (IBean bean : beansList) {
                    requestor.acceptSearchMatch(bean, file, prefix);
                }
            }
        }
    }
}

