/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.eclipse.servlet.internal;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.tools.cordovasim.eclipse.cordova.plugin.internal.PluginIdCache;
import org.jboss.tools.cordovasim.eclipse.internal.util.CordovaFileUtil;
import org.jboss.tools.cordovasim.eclipse.internal.util.ServletUtil;

public class PluginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private File pluginDir;

    public PluginServlet(File pluginDir) {
        this.pluginDir = pluginDir;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String pathInfo = req.getPathInfo();
        File file = new File(this.pluginDir, pathInfo);
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
        if (file.exists()) {
            String ifNoneMatchValue = req.getHeader("If-None-Match");
            String eTag = ServletUtil.generateEtag(file);
            if (ifNoneMatchValue != null && eTag.equals(ifNoneMatchValue)) {
                resp.setHeader("Etag", eTag);
                resp.setStatus(304);
            } else {
                String uri = req.getRequestURI();
                String pluginId = this.getPluginId(uri);
                if (pluginId == null) {
                    resp.sendError(500);
                } else {
                    String content = null;
                    try {
                        content = CordovaFileUtil.generatePluginContent(file, pluginId);
                    }
                    catch (IOException e) {
                        resp.sendError(500);
                    }
                    if (content != null) {
                        resp.setStatus(200);
                        resp.setContentType("application/javascript");
                        resp.setHeader("Etag", eTag);
                        resp.getWriter().write(content);
                    }
                }
            }
        } else {
            resp.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    private String getPluginId(String uri) {
        return PluginIdCache.getPluginId(uri.substring(1));
    }
}

