/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.blueprint.internal;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintDefaultsDefinition;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintParser;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintReferenceAttributeCallback;
import org.springframework.ide.eclipse.osgi.blueprint.internal.jaxb.Tavailability;
import org.springframework.ide.eclipse.osgi.blueprint.internal.util.AttributeCallback;
import org.springframework.ide.eclipse.osgi.blueprint.internal.util.ParserUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BlueprintReferenceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String LISTENERS_PROP = "referenceListener";
    private static final String TIMEOUT = "timeout";
    private static final String REFERENCE_LISTENER = "reference-listener";
    private static final String REF = "ref";
    private static final String INTERFACE = "interface";
    private static final String AVAILABILITY = "availability";

    private BlueprintDefaultsDefinition resolveDefaults(Document document, ParserContext parserContext) {
        return new BlueprintDefaultsDefinition(document, parserContext);
    }

    private void applyDefaultTimeout(BeanDefinitionBuilder builder, BlueprintDefaultsDefinition defaults) {
        builder.addPropertyValue(TIMEOUT, (Object)new TypedStringValue(defaults.getTimeout()));
    }

    private void parseAttributes(Element element, BeanDefinitionBuilder builder, AttributeCallback[] callbacks, BlueprintDefaultsDefinition defaults) {
        BlueprintReferenceAttributeCallback blueprintCallback = new BlueprintReferenceAttributeCallback();
        TimeoutAttributeCallback timeoutCallback = new TimeoutAttributeCallback();
        ParserUtils.parseCustomAttributes(element, builder, ParserUtils.mergeCallbacks(callbacks, new AttributeCallback[]{timeoutCallback, blueprintCallback}));
        if (!timeoutCallback.isTimeoutSpecified) {
            this.applyDefaultTimeout(builder, defaults);
        }
    }

    private Object parsePropertySubElement(ParserContext context, Element beanDef, BeanDefinition beanDefinition) {
        return BlueprintParser.parsePropertySubElement(context, beanDef, beanDefinition);
    }

    private void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        BlueprintDefaultsDefinition defaults = this.resolveDefaults(element.getOwnerDocument(), context);
        ReferenceAttributesCallback callback = new ReferenceAttributesCallback();
        this.parseAttributes(element, builder, new AttributeCallback[]{callback}, defaults);
        if (!this.isCardinalitySpecified(builder)) {
            this.applyDefaultCardinality(builder, defaults);
        }
        this.parseNestedElements(element, context, builder);
    }

    private boolean isCardinalitySpecified(BeanDefinitionBuilder builder) {
        return builder.getRawBeanDefinition().getPropertyValues().getPropertyValue(AVAILABILITY) != null;
    }

    private String getListenerElementName() {
        return REFERENCE_LISTENER;
    }

    private String generateBeanName(String id, BeanDefinition def, ParserContext parserContext) {
        String name;
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String generated = name = "." + id + BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)def, (BeanDefinitionRegistry)registry);
        int counter = 0;
        while (registry.containsBeanDefinition(generated)) {
            generated = String.valueOf(name) + "#" + counter;
            if (parserContext.isNested()) {
                generated = generated.concat("#generated");
            }
            ++counter;
        }
        return generated;
    }

    private void applyDefaults(ParserContext parserContext, BlueprintDefaultsDefinition defaults, BeanDefinitionBuilder builder) {
        if (parserContext.isNested()) {
            builder.setScope(parserContext.getContainingBeanDefinition().getScope());
        }
        if (parserContext.isDefaultLazyInit()) {
            builder.setLazyInit(true);
        }
        if (defaults.getDefaultInitialization()) {
            builder.setLazyInit(defaults.getDefaultInitialization());
        }
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = this.generateBeanName("", (BeanDefinition)definition, parserContext);
        }
        return id;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        builder.setRole(2);
        builder.getRawBeanDefinition().setSynthetic(true);
        builder.getRawBeanDefinition().setFactoryBeanName("internal");
        builder.getRawBeanDefinition().setSource(parserContext.extractSource((Object)element));
        BlueprintDefaultsDefinition defaults = this.resolveDefaults(element.getOwnerDocument(), parserContext);
        this.applyDefaults(parserContext, defaults, builder);
        this.doParse(element, parserContext, builder);
        AbstractBeanDefinition def = builder.getBeanDefinition();
        return def;
    }

    private void applyDefaultCardinality(BeanDefinitionBuilder builder, BlueprintDefaultsDefinition defaults) {
        builder.addPropertyValue(AVAILABILITY, (Object)defaults.getAvailability());
    }

    private void parseNestedElements(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        this.parseListeners(element, this.getListenerElementName(), context, builder);
    }

    private void parseListeners(Element element, String subElementName, ParserContext context, BeanDefinitionBuilder builder) {
        List listeners = DomUtils.getChildElementsByTagName((Element)element, (String)subElementName);
        ManagedList listenersRef = new ManagedList();
        for (Element listnr : listeners) {
            Object target = null;
            String targetName = null;
            NodeList nl = listnr.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node instanceof Element) {
                    Element beanDef = (Element)node;
                    if (listnr.hasAttribute(REF)) {
                        context.getReaderContext().error("nested bean declaration is not allowed if 'ref' attribute has been specified", (Object)beanDef);
                    }
                    if ((target = this.parsePropertySubElement(context, beanDef, (BeanDefinition)builder.getRawBeanDefinition())) instanceof RuntimeBeanReference) {
                        targetName = ((RuntimeBeanReference)target).getBeanName();
                    }
                }
                ++i;
            }
            MutablePropertyValues vals = new MutablePropertyValues();
            NamedNodeMap attrs = listnr.getAttributes();
            int x = 0;
            while (x < attrs.getLength()) {
                Attr attribute = (Attr)attrs.item(x);
                String name = attribute.getLocalName();
                if (REF.equals(name)) {
                    targetName = attribute.getValue();
                } else {
                    vals.addPropertyValue(Conventions.attributeNameToPropertyName((String)name), (Object)attribute.getValue());
                }
                ++x;
            }
            RootBeanDefinition wrapperDef = new RootBeanDefinition();
            if (targetName != null) {
                AbstractBeanDefinition bd = builder.getRawBeanDefinition();
                LinkedHashSet<String> str = (LinkedHashSet<String>)bd.getAttribute("org.eclipse.gemini.blueprint.config.internal.reference.listener.ref.attr");
                if (str == null) {
                    str = new LinkedHashSet<String>(2);
                    bd.setAttribute("org.eclipse.gemini.blueprint.config.internal.reference.listener.ref.attr", str);
                }
                str.add(targetName);
                vals.addPropertyValue(REF, (Object)targetName);
            } else {
                vals.addPropertyValue("bean", target);
            }
            wrapperDef.setPropertyValues(vals);
            wrapperDef.setRole(2);
            listenersRef.add((Object)wrapperDef);
        }
        PropertyValue previousListener = builder.getRawBeanDefinition().getPropertyValues().getPropertyValue(LISTENERS_PROP);
        if (previousListener != null) {
            ManagedList ml = (ManagedList)previousListener.getValue();
            listenersRef.addAll(0, (Collection)ml);
        }
        builder.addPropertyValue(LISTENERS_PROP, (Object)listenersRef);
    }

    class ReferenceAttributesCallback
    implements AttributeCallback {
        ReferenceAttributesCallback() {
        }

        @Override
        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            String value = attribute.getValue().trim();
            if (BlueprintReferenceBeanDefinitionParser.AVAILABILITY.equals(name)) {
                Tavailability avail = Tavailability.fromValue(value);
                builder.addPropertyValue(BlueprintReferenceBeanDefinitionParser.AVAILABILITY, (Object)avail);
                return false;
            }
            if (BlueprintReferenceBeanDefinitionParser.INTERFACE.equals(name)) {
                builder.addPropertyValue(BlueprintReferenceBeanDefinitionParser.INTERFACE, (Object)value);
                return false;
            }
            return true;
        }
    }

    static class TimeoutAttributeCallback
    implements AttributeCallback {
        boolean isTimeoutSpecified = false;

        TimeoutAttributeCallback() {
        }

        @Override
        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            if (BlueprintReferenceBeanDefinitionParser.TIMEOUT.equals(name)) {
                this.isTimeoutSpecified = true;
            }
            return true;
        }
    }
}

