/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.blueprint.internal;

import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.ide.eclipse.osgi.blueprint.internal.jaxb.Tavailability;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlueprintDefaultsDefinition {
    private static final String BLUEPRINT_NS = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    private static final String DEFAULT_TIMEOUT = "default-timeout";
    private static final String DEFAULT_AVAILABILITY = "default-availability";
    private static final String TIMEOUT_DEFAULT = "300000";
    private static final String DEFAULT_INITIALIZATION = "default-activation";
    private static final String LAZY_INITIALIZATION = "lazy";
    private static final boolean INITIALIZATION_DEFAULT = false;
    private boolean defaultInitialization;
    private String timeout = "300000";
    private Tavailability availability = Tavailability.MANDATORY;

    public BlueprintDefaultsDefinition(Document doc, ParserContext parserContext) {
        String initialization;
        Element root = doc.getDocumentElement();
        String timeout = this.getAttribute(root, BLUEPRINT_NS, DEFAULT_TIMEOUT);
        this.setTimeout(StringUtils.hasText((String)timeout) ? timeout.trim() : TIMEOUT_DEFAULT);
        String availability = this.getAttribute(root, BLUEPRINT_NS, DEFAULT_AVAILABILITY);
        if (StringUtils.hasText((String)availability)) {
            Tavailability avail = Tavailability.fromValue(availability);
            this.setAvailability(avail);
        }
        this.defaultInitialization = StringUtils.hasText((String)(initialization = this.getAttribute(root, BLUEPRINT_NS, DEFAULT_INITIALIZATION))) ? initialization.trim().equalsIgnoreCase(LAZY_INITIALIZATION) : false;
    }

    public boolean getDefaultInitialization() {
        return this.defaultInitialization;
    }

    public String getTimeout() {
        return this.timeout;
    }

    protected void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public Tavailability getAvailability() {
        return this.availability;
    }

    protected void setAvailability(Tavailability availability) {
        this.availability = availability;
    }

    protected String getAttribute(Element root, String ns, String attributeName) {
        String value = root.getAttributeNS(ns, attributeName);
        return !StringUtils.hasText((String)value) ? root.getAttribute(attributeName) : value;
    }
}

