/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.osgi.blueprint;

import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.ide.eclipse.osgi.blueprint.internal.BlueprintParser;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class TypeConverterBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public static final String TYPE_CONVERTERS = "type-converters";

    TypeConverterBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder registrarDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition();
        List components = DomUtils.getChildElementsByTagName((Element)element, (String)"bean");
        List componentRefs = DomUtils.getChildElementsByTagName((Element)element, (String)"ref");
        ManagedList converterList = new ManagedList(componentRefs.size() + components.size());
        for (Element component : components) {
            Object object = BlueprintParser.parsePropertySubElement(parserContext, component, (BeanDefinition)registrarDefinitionBuilder.getRawBeanDefinition());
            this.checkConverter(object, parserContext, component);
            converterList.add(object);
        }
        for (Element componentRef : componentRefs) {
            Object converter = BlueprintParser.parsePropertySubElement(parserContext, componentRef, (BeanDefinition)registrarDefinitionBuilder.getRawBeanDefinition());
            this.checkConverter(converter, parserContext, componentRef);
            converterList.add(converter);
        }
        registrarDefinitionBuilder.addPropertyValue("converters", (Object)converterList);
        registrarDefinitionBuilder.setRole(2);
        registrarDefinitionBuilder.getRawBeanDefinition().setSynthetic(true);
        return registrarDefinitionBuilder.getBeanDefinition();
    }

    private void checkConverter(Object object, ParserContext parserContext, Element element) {
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return TYPE_CONVERTERS;
    }
}

