/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.sf.eclipsecs.core.transformer.CheckstyleSetting;
import net.sf.eclipsecs.core.util.CheckstyleLog;

public class CheckstyleFileWriter {
    private final CheckstyleSetting mCheckstyleSetting;

    public CheckstyleFileWriter(CheckstyleSetting setting, String file) {
        this.mCheckstyleSetting = setting;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fw = new FileOutputStream(file);){
                this.writeXMLFile(fw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            CheckstyleLog.log(e);
        }
    }

    private void writeXMLFile(OutputStream bw) throws IOException {
        bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes("UTF-8"));
        bw.write("<module name=\"Checker\">\n".getBytes("UTF-8"));
        bw.write("<property name=\"severity\" value=\"warning\"/>\n".getBytes("UTF-8"));
        this.writeModules(this.mCheckstyleSetting.getmCheckerModules(), bw);
        bw.write("<module name=\"TreeWalker\">\n".getBytes("UTF-8"));
        this.writeModules(this.mCheckstyleSetting.getmTreeWalkerModules(), bw);
        bw.write("</module>\n".getBytes("UTF-8"));
        bw.write("</module>\n".getBytes("UTF-8"));
    }

    private void writeModules(HashMap<String, HashMap<String, String>> modules, OutputStream bw) throws IOException {
        for (String module : modules.keySet()) {
            if (modules.get(module) == null) {
                bw.write(("<module name=\"" + module + "\"/>\n").getBytes("UTF-8"));
                continue;
            }
            bw.write(("<module name=\"" + module + "\">\n").getBytes("UTF-8"));
            this.writeProperty(modules.get(module), bw);
            bw.write("</module>\n".getBytes("UTF-8"));
        }
    }

    private void writeProperty(HashMap<String, String> properties, OutputStream bw) throws IOException {
        for (String prop : properties.keySet()) {
            bw.write(("<property name=\"" + prop + "\" value=\"" + properties.get(prop) + "\"/>\n").getBytes("UTF-8"));
        }
    }
}

