/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.URIUtil;

public class InternalConfigurationType
extends ConfigurationType {
    public static String resolveLocationInWorkspace(String location) {
        IPath configPath = CheckstylePlugin.getDefault().getStateLocation();
        configPath = configPath.append(location);
        return configPath.toString();
    }

    @Override
    protected URL resolveLocation(ICheckConfiguration checkConfiguration) throws IOException {
        String location = checkConfiguration.getLocation();
        location = InternalConfigurationType.resolveLocationInWorkspace(location);
        return new File(location).toURI().toURL();
    }

    @Override
    public void notifyCheckConfigRemoved(ICheckConfiguration checkConfiguration) throws CheckstylePluginException {
        super.notifyCheckConfigRemoved(checkConfiguration);
        URL configFileURL = checkConfiguration.getResolvedConfigurationFileURL();
        if (configFileURL != null) {
            try {
                File configFile = URIUtil.toFile((URI)configFileURL.toURI());
                if (configFile != null) {
                    configFile.delete();
                }
            }
            catch (URISyntaxException e) {
                CheckstylePluginException.rethrow(e);
            }
        }
    }
}

