/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PatternUtils {
    private PatternUtils() {
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        if (!isRegexSearch) {
            pattern = PatternUtils.toRegExFormat(pattern);
        }
        if (!isCaseSensitive) {
            return Pattern.compile(pattern, 74);
        }
        return Pattern.compile(pattern, 8);
    }

    private static String toRegExFormat(String pattern) {
        StringBuffer regex = new StringBuffer(pattern.length());
        boolean escaped = false;
        boolean quoting = false;
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == '*' && !escaped) {
                if (quoting) {
                    regex.append("\\E");
                    quoting = false;
                }
                regex.append(".*");
                escaped = false;
            } else if (c == '?' && !escaped) {
                if (quoting) {
                    regex.append("\\E");
                    quoting = false;
                }
                regex.append(".");
                escaped = false;
            } else if (c == '\\' && !escaped) {
                escaped = true;
            } else if (c == '\\' && escaped) {
                escaped = false;
                if (quoting) {
                    regex.append("\\E");
                    quoting = false;
                }
                regex.append("\\\\");
            } else {
                if (!quoting) {
                    regex.append("\\Q");
                    quoting = true;
                }
                if (escaped && c != '*' && c != '?' && c != '\\') {
                    regex.append('\\');
                }
                regex.append(c);
                escaped = c == '\\';
            }
            ++i;
        }
        if (quoting) {
            regex.append("\\E");
        }
        return regex.toString();
    }
}

