/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;

public final class MarkerUtils {
    public static final String ORIGINATING_RESOURCE_KEY = "originatingResource";
    public static final String ELEMENT_ID_KEY = "elementId";

    public static int getHighestSeverityFromMarkersInRange(IResource resource, String markerId, int startLine, int endLine) {
        int severity = -1;
        if (resource != null) {
            for (IMarker marker : MarkerUtils.getAllMarkersInRange(resource, markerId, startLine, endLine)) {
                int sev = marker.getAttribute("severity", -1);
                if (sev == 1) {
                    severity = sev;
                    continue;
                }
                if (sev != 2) continue;
                severity = sev;
                break;
            }
        }
        return severity;
    }

    public static Set<IMarker> getAllMarkersInRange(IResource resource, String markerId, int startLine, int endLine) {
        HashSet<IMarker> foundMarkers = new HashSet<IMarker>();
        if (resource != null) {
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers(markerId, true, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (startLine == -1 || MarkerUtils.isMarkerInRange(marker, startLine, endLine)) {
                        foundMarkers.add(marker);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return foundMarkers;
    }

    public static boolean isMarkerInRange(IMarker marker, int startLine, int endLine) throws CoreException {
        if (startLine >= 0 && endLine >= startLine && marker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int line = marker.getAttribute("lineNumber", -1);
            return line >= startLine && line <= endLine;
        }
        return false;
    }

    public static void deleteAllMarkers(IResource resource, String id) {
        if (resource != null && resource.isAccessible()) {
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers(id, true, 1);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    marker.delete();
                    ++n2;
                }
            }
            catch (CoreException e) {
                CorePlugin.log(e);
            }
        }
    }

    public static void deleteMarkers(IResource resource, String id) {
        if (resource != null && resource.isAccessible()) {
            try {
                resource.deleteMarkers(id, true, 2);
            }
            catch (CoreException e) {
                CorePlugin.log(e);
            }
        }
    }
}

