/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;
import org.springframework.ide.eclipse.config.ui.wizards.ConfigWizardsMessages;
import org.springframework.ide.eclipse.config.ui.wizards.NamespaceSelectionWizardPage;
import org.springsource.ide.eclipse.commons.ui.StsUiImages;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespaceConfigWizard
extends Wizard
implements INewWizard {
    protected static final String ATTR_NAMESPACE_PREFIX = "xmlns:";
    protected static final String ATTR_SCHEMA_LOCATION = "xsi:schemaLocation";
    private NamespaceSelectionWizardPage namespacePage = null;
    private Element beansElement = null;
    private final IStructuredFormatProcessor formatProcessor = new ShallowFormatProcessorXML();
    private IStructuredModel model;
    private EditorPart editor;
    private final IFile file;

    public NamespaceConfigWizard(IFile xmlConfigFile) throws CoreException {
        this.file = xmlConfigFile;
        this.beansElement = this.getBeansXmlElement(xmlConfigFile);
        this.setDialogSettings(BeansUIPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(StsUiImages.NAMESPACE_CONFIG_ICON);
        this.setWindowTitle(ConfigWizardsMessages.NamespaceConfig_windowTitle);
    }

    public NamespaceConfigWizard(IFile xmlConfigFile, EditorPart editor) throws CoreException {
        this(xmlConfigFile);
        this.editor = editor;
    }

    public void addPages() {
        super.addPages();
        this.namespacePage = new NamespaceSelectionWizardPage("xsdPage", this.beansElement, this.file);
        this.addPage((IWizardPage)this.namespacePage);
    }

    private void addSelectedNamespaces() {
        List<INamespaceDefinition> namespaces = this.namespacePage.getXmlSchemaDefinitions();
        Map<INamespaceDefinition, String> schemaVersions = this.namespacePage.getSchemaVersions();
        String defaultNamespaceUri = this.beansElement.getAttribute("xmlns");
        for (INamespaceDefinition currNamespaceDefinition : namespaces) {
            if (!currNamespaceDefinition.getNamespaceURI().equals(defaultNamespaceUri)) {
                this.beansElement.setAttribute(ATTR_NAMESPACE_PREFIX + currNamespaceDefinition.getNamespacePrefix((IResource)this.file), currNamespaceDefinition.getNamespaceURI());
            }
            if (currNamespaceDefinition.getDefaultSchemaLocation((IResource)this.file) == null) continue;
            String schemaLocationAttrVal = this.beansElement.getAttribute(ATTR_SCHEMA_LOCATION);
            String currNamespaceDefSchemaLocationVal = this.getSchemaLocationValue(currNamespaceDefinition, schemaVersions);
            schemaLocationAttrVal = schemaLocationAttrVal == null ? currNamespaceDefSchemaLocationVal : String.valueOf(schemaLocationAttrVal) + "\n\t\t" + currNamespaceDefSchemaLocationVal;
            this.beansElement.setAttribute(ATTR_SCHEMA_LOCATION, schemaLocationAttrVal.trim());
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.releaseFromEdit();
            this.model = null;
        }
        super.dispose();
    }

    private void formatNamespaces() {
        NodeList childNodes = this.beansElement.getChildNodes();
        ArrayList<Node> childrenToRemove = new ArrayList<Node>();
        ArrayList<Node> childNodeCopies = new ArrayList<Node>();
        int i = 0;
        while (i < childNodes.getLength()) {
            childrenToRemove.add(childNodes.item(i));
            childNodeCopies.add(childNodes.item(i).cloneNode(true));
            ++i;
        }
        i = 0;
        while (i < childrenToRemove.size()) {
            this.beansElement.removeChild((Node)childrenToRemove.get(i));
            ++i;
        }
        this.formatProcessor.formatNode((Node)this.beansElement);
        i = 0;
        while (i < childNodeCopies.size()) {
            this.beansElement.appendChild((Node)childNodeCopies.get(i));
            ++i;
        }
    }

    private Element getBeansXmlElement(IFile xmlConfigFile) throws CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        try {
            this.model = modelManager.getModelForEdit(xmlConfigFile);
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", "Could not open model for editing"));
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", "Could not open model for editing"));
        }
        if (this.model == null) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", "Could not open model for editing"));
        }
        IStructuredDocumentRegion beansRegion = null;
        IStructuredDocumentRegion[] iStructuredDocumentRegionArray = this.model.getStructuredDocument().getStructuredDocumentRegions();
        int n = iStructuredDocumentRegionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStructuredDocumentRegion currRegion = iStructuredDocumentRegionArray[n2];
            if (currRegion.getFullText().startsWith("<beans")) {
                beansRegion = currRegion;
                break;
            }
            ++n2;
        }
        if (beansRegion == null) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", "Could not open model for editing"));
        }
        Element beansXmlElement = (Element)this.model.getIndexedRegion(beansRegion.getStartOffset());
        if (beansXmlElement == null || !beansXmlElement.getNodeName().startsWith("beans")) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", "Could not open model for editing"));
        }
        return beansXmlElement;
    }

    private String getSchemaLocationValue(INamespaceDefinition namespaceDefinition, Map<INamespaceDefinition, String> schemaVersions) {
        String schemaVersion = schemaVersions.get(namespaceDefinition);
        if (schemaVersion == null) {
            schemaVersion = namespaceDefinition.getDefaultSchemaLocation((IResource)this.file);
        }
        return String.valueOf(namespaceDefinition.getNamespaceURI()) + " " + schemaVersion;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(ConfigWizardsMessages.NamespaceConfig_windowTitle);
        this.setDefaultPageImageDescriptor(BeansUIImages.DESC_WIZ_CONFIG);
    }

    public boolean performFinish() {
        if (this.editor != null && this.editor.getAdapter(StructuredTextEditor.class) != null) {
            StructuredTextEditor textEditor = (StructuredTextEditor)this.editor.getAdapter(StructuredTextEditor.class);
            textEditor.getTextViewer().setRedraw(false);
            this.performFinishHelper();
            textEditor.getTextViewer().setRedraw(true);
        } else {
            this.performFinishHelper();
        }
        return true;
    }

    private void performFinishHelper() {
        this.model.beginRecording((Object)this);
        this.removeNamespaceInformation();
        this.addSelectedNamespaces();
        this.formatProcessor.formatNode((Node)this.beansElement);
        this.model.endRecording((Object)this);
    }

    private void removeNamespaceInformation() {
        this.beansElement.removeAttribute(ATTR_SCHEMA_LOCATION);
        NamedNodeMap beanAttributes = this.beansElement.getAttributes();
        ArrayList<String> attributesToRemove = new ArrayList<String>();
        int i = 0;
        while (i < beanAttributes.getLength()) {
            Node currAttributeNode = beanAttributes.item(i);
            String currAttributeName = currAttributeNode.getNodeName();
            if (currAttributeName.toLowerCase().startsWith(ATTR_NAMESPACE_PREFIX) && !currAttributeName.toLowerCase().startsWith("xmlns:xsi")) {
                attributesToRemove.add(currAttributeName);
            }
            ++i;
        }
        for (String currAttributeName : attributesToRemove) {
            this.beansElement.removeAttribute(currAttributeName);
        }
    }
}

