/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resourcesListeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProviderType;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.JobUtility;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;

public class FileModificationManager
implements IResourceChangeListener,
ISaveParticipant,
Preferences.IPropertyChangeListener {
    private boolean ignoreManagedDerivedResources = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_managed_derived_resources");
    protected int INTERESTING_CHANGES = 323840;

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            final ArrayList modifiedResources = new ArrayList();
            final ArrayList modifiedInfiniteDepthResources = new ArrayList();
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.isDerived()) {
                        LocalResourceStatus aStatus = null;
                        try {
                            aStatus = SVNProviderPlugin.getPlugin().getStatusCacheManager().getStatusFromCache(resource);
                        }
                        catch (SVNException e) {
                            SVNProviderPlugin.log(4, e.getMessage(), (Throwable)((Object)e));
                        }
                        if (aStatus == null || !aStatus.isManaged()) {
                            return false;
                        }
                        if (FileModificationManager.this.ignoreManagedDerivedResources) {
                            return false;
                        }
                    }
                    if (resource.getType() == 1) {
                        if (delta.getKind() == 4 && resource.exists()) {
                            if ((delta.getFlags() & FileModificationManager.this.INTERESTING_CHANGES) != 0) {
                                modifiedResources.add(resource);
                                return true;
                            }
                        } else {
                            if (delta.getKind() == 1) {
                                modifiedResources.add(resource);
                                return true;
                            }
                            if (delta.getKind() == 2) {
                                modifiedResources.add(resource);
                                return true;
                            }
                        }
                    } else {
                        if (resource.getType() == 2) {
                            if (delta.getKind() == 1) {
                                if (resource.getParent() != null && !modifiedInfiniteDepthResources.contains(resource.getParent())) {
                                    modifiedInfiniteDepthResources.add(resource.getParent());
                                } else {
                                    modifiedInfiniteDepthResources.add(resource);
                                }
                                return false;
                            }
                            if (delta.getKind() == 2) {
                                modifiedInfiniteDepthResources.add(resource);
                                return false;
                            }
                            return true;
                        }
                        if (resource.getType() == 4) {
                            IProject project = (IProject)resource;
                            if ((delta.getKind() & 2) != 0) {
                                SVNWorkspaceRoot.unsetManagedBySubclipse(project);
                                return false;
                            }
                            if (!project.isAccessible()) {
                                return false;
                            }
                            if (delta.getKind() != 1 && (delta.getFlags() & 0x4000) != 0) {
                                return false;
                            }
                            if (!SVNWorkspaceRoot.isManagedBySubclipse(project)) {
                                if (delta.getKind() == 1) {
                                    FileModificationManager.this.autoShareProjectIfSVNWorkingCopy(project);
                                }
                                return false;
                            }
                            if (delta.getKind() == 1) {
                                modifiedInfiniteDepthResources.add(resource);
                                return false;
                            }
                            if (delta.getKind() == 2) {
                                modifiedInfiniteDepthResources.add(resource);
                                return false;
                            }
                        }
                    }
                    return true;
                }
            });
            if (!modifiedResources.isEmpty() || !modifiedInfiniteDepthResources.isEmpty()) {
                IProject project;
                IResource resource;
                int n;
                int n2;
                IResource[] iResourceArray;
                IResource[] resources;
                ArrayList<IProject> projects = new ArrayList<IProject>();
                if (!modifiedResources.isEmpty()) {
                    iResourceArray = resources = modifiedResources.toArray(new IResource[modifiedResources.size()]);
                    n2 = resources.length;
                    n = 0;
                    while (n < n2) {
                        resource = iResourceArray[n];
                        project = resource.getProject();
                        if (project != null && !projects.contains(project)) {
                            projects.add(project);
                        }
                        ++n;
                    }
                }
                if (!modifiedInfiniteDepthResources.isEmpty()) {
                    iResourceArray = resources = modifiedInfiniteDepthResources.toArray(new IResource[modifiedInfiniteDepthResources.size()]);
                    n2 = resources.length;
                    n = 0;
                    while (n < n2) {
                        resource = iResourceArray[n];
                        project = resource.getProject();
                        if (project != null && !projects.contains(project)) {
                            projects.add(project);
                        }
                        ++n;
                    }
                }
                IProject[] projectArray = new IProject[projects.size()];
                projects.toArray(projectArray);
                JobUtility.scheduleJob("Refresh SVN status cache", new Runnable(){

                    @Override
                    public void run() {
                        IResource[] resources;
                        if (!modifiedResources.isEmpty()) {
                            resources = modifiedResources.toArray(new IResource[modifiedResources.size()]);
                            FileModificationManager.this.refreshStatus(resources);
                            SVNProviderPlugin.broadcastModificationStateChanges(resources);
                        }
                        if (!modifiedInfiniteDepthResources.isEmpty()) {
                            FileModificationManager.this.refreshStatusInfinite(modifiedInfiniteDepthResources);
                            resources = modifiedInfiniteDepthResources.toArray(new IResource[modifiedInfiniteDepthResources.size()]);
                            SVNProviderPlugin.broadcastModificationStateChanges(resources);
                        }
                    }
                }, new RefreshStatusCacheSchedulingRule(MultiRule.combine((ISchedulingRule[])projectArray)), false);
            }
        }
        catch (CoreException e) {
            SVNProviderPlugin.log(e.getStatus());
        }
    }

    private void refreshStatusInfinite(Collection<? extends IResource> resources) {
        HashSet<IResource> alreadyRefreshedResources = new HashSet<IResource>();
        for (IResource iResource : resources) {
            if (alreadyRefreshedResources.contains(iResource)) continue;
            try {
                IResource[] refreshedResources = SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus(iResource, true);
                alreadyRefreshedResources.addAll(Arrays.asList(refreshedResources));
            }
            catch (SVNException e) {
                SVNProviderPlugin.log(4, e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    private void refreshStatus(IResource[] resources) {
        HashSet<IContainer> foldersToRefresh = new HashSet<IContainer>(resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resources.length == 1 && resources[0].getType() == 1) {
                try {
                    SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus(resource, false);
                }
                catch (SVNException e) {
                    SVNProviderPlugin.log(4, e.getMessage(), (Throwable)((Object)e));
                }
            } else if (resource.getType() == 1) {
                foldersToRefresh.add(resource.getParent());
            } else {
                foldersToRefresh.add((IContainer)resource);
            }
            ++n2;
        }
        this.refreshStatusInfinite(foldersToRefresh);
    }

    public void registerSaveParticipant() throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ISavedState ss = ws.addSaveParticipant((Plugin)SVNProviderPlugin.getPlugin(), (ISaveParticipant)this);
        if (ss != null) {
            ss.processResourceChangeEvents((IResourceChangeListener)this);
        }
        ws.removeSaveParticipant((Plugin)SVNProviderPlugin.getPlugin());
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) {
    }

    private void autoShareProjectIfSVNWorkingCopy(IProject project) {
        ISVNClientAdapter client = null;
        try {
            try {
                client = SVNProviderPlugin.getPlugin().getSVNClient();
                SVNProviderPlugin.disableConsoleLogging();
                ISVNInfo info = client.getInfoFromWorkingCopy(project.getLocation().toFile());
                if (info != null) {
                    SVNTeamProviderType.getAutoShareJob().share(project);
                }
            }
            catch (Exception exception) {
                SVNProviderPlugin.enableConsoleLogging();
                if (client != null) {
                    SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
                }
            }
        }
        finally {
            SVNProviderPlugin.enableConsoleLogging();
            if (client != null) {
                SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(client);
            }
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().equals("ignore_managed_derived_resources")) {
            this.ignoreManagedDerivedResources = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_managed_derived_resources");
        }
    }

    private class RefreshStatusCacheSchedulingRule
    implements ISchedulingRule {
        public ISchedulingRule schedulingRule;

        public RefreshStatusCacheSchedulingRule(ISchedulingRule schedulingRule) {
            this.schedulingRule = schedulingRule;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof RefreshStatusCacheSchedulingRule) {
                return this.schedulingRule.contains(((RefreshStatusCacheSchedulingRule)rule).getSchedulingRule());
            }
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof RefreshStatusCacheSchedulingRule) {
                return this.schedulingRule.isConflicting(((RefreshStatusCacheSchedulingRule)rule).getSchedulingRule());
            }
            return false;
        }

        public ISchedulingRule getSchedulingRule() {
            return this.schedulingRule;
        }
    }
}

