/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.tigris.subversion.subclipse.core.resources.ISVNTreeConflict;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;

public class SVNTreeConflict
implements ISVNTreeConflict,
IAdaptable {
    private ISVNStatus status;

    public SVNTreeConflict(ISVNStatus status) {
        this.status = status;
    }

    @Override
    public SVNConflictDescriptor getConflictDescriptor() {
        return this.status.getConflictDescriptor();
    }

    @Override
    public String getDescription() {
        String operation;
        String action;
        String reason;
        switch (this.status.getConflictDescriptor().getReason()) {
            case 0: {
                reason = "edit";
                break;
            }
            case 1: {
                reason = "obstruction";
                break;
            }
            case 2: {
                reason = "delete";
                break;
            }
            case 3: {
                reason = "missing";
                break;
            }
            case 4: {
                reason = "unversioned";
                break;
            }
            case 5: {
                reason = "add";
                break;
            }
            default: {
                reason = Integer.toString(this.status.getConflictDescriptor().getReason());
            }
        }
        switch (this.status.getConflictDescriptor().getAction()) {
            case 0: {
                action = "edit";
                break;
            }
            case 1: {
                action = "add";
                break;
            }
            case 2: {
                action = "delete";
                break;
            }
            default: {
                action = Integer.toString(this.status.getConflictDescriptor().getAction());
            }
        }
        switch (this.status.getConflictDescriptor().getOperation()) {
            case 0: {
                operation = "none";
                break;
            }
            case 1: {
                operation = "update";
                break;
            }
            case 2: {
                operation = "switch";
                break;
            }
            case 3: {
                operation = "merge";
                break;
            }
            default: {
                operation = Integer.toString(this.status.getConflictDescriptor().getOperation());
            }
        }
        return "local " + reason + ", incoming " + action + " upon " + operation;
    }

    @Override
    public ISVNStatus getStatus() {
        return this.status;
    }

    public IResource getResource() {
        return File2Resource.getResource(this.status.getFile());
    }

    public Object getAdapter(Class adapterType) {
        IResource resource;
        if (IFile.class == adapterType && (resource = this.getResource()) instanceof IFile) {
            IFile file = (IFile)resource;
            return file;
        }
        if (IResource.class == adapterType) {
            return this.getResource();
        }
        return null;
    }
}

