/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CheckoutCommand
implements ISVNCommand {
    private ISVNRemoteFolder[] resources;
    private IProject[] projects;
    private IPath projectRoot;
    private SVNRevision svnRevision = SVNRevision.HEAD;
    private int depth = 5;
    private boolean ignoreExternals = false;
    private boolean force = true;
    private boolean refreshProjects = true;
    private List<IProject> createProjectList = new ArrayList<IProject>();
    private List<IProject> manageProjectList = new ArrayList<IProject>();

    public CheckoutCommand(ISVNRemoteFolder[] resources, IProject[] projects) {
        this(resources, projects, null);
    }

    public CheckoutCommand(ISVNRemoteFolder[] resources, IProject[] projects, IPath root) {
        this.resources = resources;
        this.projects = projects;
        this.projectRoot = root;
    }

    protected void basicRun(IProject project, ISVNRemoteFolder resource, IProgressMonitor pm) throws SVNException {
        block18: {
            ISVNClientAdapter svnClient = null;
            if (pm != null) {
                pm.beginTask(null, 1000);
            }
            try {
                File destPath;
                boolean createProject = false;
                svnClient = resource.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(pm, svnClient));
                this.scrubProject(resource, project, pm != null ? Policy.subMonitorFor(pm, 100) : null);
                if (project.getLocation() == null) {
                    if (this.projectRoot == null) {
                        ISVNLocalFolder root = SVNWorkspaceRoot.getSVNFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                        destPath = new File(root.getIResource().getLocation().toFile(), project.getName());
                    } else {
                        destPath = new File(this.projectRoot.toFile(), project.getName());
                    }
                    if (!destPath.exists()) {
                        destPath.mkdirs();
                    }
                    createProject = true;
                } else if (this.projectRoot != null) {
                    try {
                        destPath = new File(this.projectRoot.toFile(), project.getName());
                        this.setProjectToRoot(project, destPath);
                    }
                    catch (CoreException e) {
                        throw new SVNException("Cannot create project to checkout to", e);
                    }
                } else {
                    destPath = project.getLocation().toFile();
                }
                if (createProject) {
                    this.createProjectList.add(project);
                }
                this.checkoutProject(pm, resource, svnClient, destPath);
                SVNWorkspaceRoot.setManagedBySubclipse(project);
                if (this.refreshProjects) {
                    try {
                        project.create(null);
                        project.open(null);
                    }
                    catch (CoreException e1) {
                        throw new SVNException("Cannot create project to checkout to", e1);
                    }
                    this.refreshProject(project, pm != null ? Policy.subMonitorFor(pm, 100) : null);
                    break block18;
                }
                this.manageProjectList.add(project);
            }
            finally {
                resource.getRepository().returnSVNClient(svnClient);
                if (pm != null) {
                    pm.done();
                }
            }
        }
    }

    public List<IProject> getCreateProjectList() {
        return this.createProjectList;
    }

    public List<IProject> getManageProjectList() {
        return this.manageProjectList;
    }

    private void setProjectToRoot(IProject project, File destPath) throws CoreException {
        IProjectDescription description = project.getDescription();
        description.setLocation((IPath)new Path(destPath.getAbsolutePath()));
        project.move(description, true, null);
    }

    private void checkoutProject(IProgressMonitor pm, ISVNRemoteFolder resource, ISVNClientAdapter svnClient, File destPath) throws SVNException {
        IProgressMonitor subPm = Policy.infiniteSubMonitorFor(pm, 800);
        try {
            try {
                subPm.beginTask("", 1000);
                SVNUrl url = this.svnRevision instanceof SVNRevision.Number ? Util.getUrlForRevision(resource, (SVNRevision.Number)this.svnRevision, subPm) : resource.getUrl();
                svnClient.checkout(url, destPath, this.svnRevision, this.depth, this.ignoreExternals, this.force);
            }
            catch (SVNClientException e) {
                throw new SVNException("cannot checkout", e.operationInterrupted());
            }
        }
        finally {
            subPm.done();
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws SVNException {
        try {
            int i = 0;
            while (i < this.resources.length) {
                final IProject project = this.projects[i];
                final ISVNRemoteFolder resource = this.resources[i];
                SVNProviderPlugin.run(new ISVNRunnable(){

                    @Override
                    public void run(IProgressMonitor pm) throws SVNException {
                        CheckoutCommand.this.basicRun(project, resource, pm);
                    }
                }, (ISchedulingRule)this.projects[i], Policy.monitorFor(monitor));
                ++i;
            }
        }
        finally {
            OperationManager.getInstance().endOperation();
        }
    }

    private void scrubProject(ISVNRemoteFolder resource, IProject project, IProgressMonitor monitor) throws SVNException {
        block32: {
            if (project == null) {
                if (monitor != null) {
                    monitor.done();
                }
                return;
            }
            if (monitor != null) {
                monitor.beginTask("", 100);
                monitor.subTask(Policy.bind("SVNProvider.Scrubbing_local_project_1", project.getName()));
            }
            try {
                try {
                    File location;
                    File destPath = null;
                    if (this.projectRoot != null) {
                        destPath = new File(this.projectRoot.toFile(), project.getName());
                    }
                    if (destPath != null && !destPath.exists() && project != null && project.exists()) {
                        project.delete(8, monitor);
                        project = null;
                    }
                    if (project != null && project.exists() && (destPath == null || destPath.exists())) {
                        IProgressMonitor subMonitor;
                        if (!project.isOpen()) {
                            project.open(monitor != null ? Policy.subMonitorFor(monitor, 10) : null);
                        }
                        if (RepositoryProvider.getProvider((IProject)project) != null) {
                            RepositoryProvider.unmap((IProject)project);
                        }
                        IResource[] children = project.members(2);
                        IProgressMonitor iProgressMonitor = subMonitor = monitor != null ? Policy.subMonitorFor(monitor, 80) : null;
                        if (subMonitor != null) {
                            subMonitor.beginTask(null, children.length * 100);
                        }
                        ISVNClientAdapter clientSilent = null;
                        try {
                            int j = 0;
                            while (j < children.length) {
                                if (!children[j].getName().equals(".project")) {
                                    ISVNInfo info;
                                    block31: {
                                        if (clientSilent == null) {
                                            clientSilent = SVNProviderPlugin.getPlugin().getSVNClient();
                                        }
                                        info = null;
                                        try {
                                            SVNUrl url = new SVNUrl(String.valueOf(resource.getUrl().toString()) + "/" + children[j].getProjectRelativePath());
                                            try {
                                                try {
                                                    SVNProviderPlugin.disableConsoleLogging();
                                                    info = clientSilent.getInfo(url);
                                                }
                                                catch (SVNClientException sVNClientException) {
                                                    SVNProviderPlugin.enableConsoleLogging();
                                                    break block31;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                SVNProviderPlugin.enableConsoleLogging();
                                                throw throwable;
                                            }
                                            SVNProviderPlugin.enableConsoleLogging();
                                        }
                                        catch (MalformedURLException malformedURLException) {}
                                    }
                                    if (info != null) {
                                        children[j].delete(true, subMonitor != null ? Policy.subMonitorFor(subMonitor, 100) : null);
                                    }
                                }
                                ++j;
                            }
                            break block32;
                        }
                        finally {
                            if (subMonitor != null) {
                                subMonitor.done();
                            }
                            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(clientSilent);
                        }
                    }
                    if (project != null && (location = new File(project.getParent().getLocation().toFile(), project.getName())).exists()) {
                        this.deepDelete(location);
                    }
                }
                catch (CoreException e) {
                    throw SVNException.wrapException(e);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.subTask(" ");
                    monitor.done();
                }
            }
        }
    }

    private void deepDelete(File resource) {
        if (resource.isDirectory()) {
            File[] fileList = resource.listFiles();
            int i = 0;
            while (i < fileList.length) {
                this.deepDelete(fileList[i]);
                ++i;
            }
        }
        resource.delete();
    }

    private void refreshProject(IProject project, IProgressMonitor monitor) throws SVNException {
        if (monitor != null) {
            monitor.beginTask("", 100);
            monitor.subTask(Policy.bind("SVNProvider.Creating_project_1", project.getName()));
        }
        try {
            try {
                RepositoryProvider.map((IProject)project, (String)SVNProviderPlugin.getTypeId());
                RepositoryProvider.getProvider((IProject)project, (String)SVNProviderPlugin.getTypeId());
            }
            catch (TeamException e) {
                throw new SVNException("Cannot map the project with svn provider", e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.subTask(" ");
                monitor.done();
            }
        }
    }

    public void setSvnRevision(SVNRevision svnRevision) {
        this.svnRevision = svnRevision;
    }

    public void setRefreshProjects(boolean refreshProjects) {
        this.refreshProjects = refreshProjects;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

