/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.m2e.internal;

import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.sonarlint.eclipse.core.SonarLintLogger;

public class M2eUtils {
    private M2eUtils() {
    }

    public static boolean isInNestedModule(IFile file) {
        IProject project = file.getProject();
        try {
            IMavenProjectRegistry projectManager;
            IMavenProjectFacade projectFacade;
            if (project.hasNature("org.eclipse.m2e.core.maven2Nature") && (projectFacade = (projectManager = MavenPlugin.getMavenProjectRegistry()).create(project, null)) != null && "pom".equals(projectFacade.getPackaging())) {
                return !M2eUtils.toSpecificFile(file).equals((Object)file);
            }
        }
        catch (CoreException ex) {
            SonarLintLogger.get().error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private static IFile toSpecificFile(IFile file) {
        IFile moreSpecific;
        IFile finalFile = file;
        IPath rawLocation = file.getRawLocation();
        if (rawLocation != null && (moreSpecific = M2eUtils.resourceForLocation(rawLocation)) != null) {
            finalFile = moreSpecific;
        }
        return finalFile;
    }

    private static IFile resourceForLocation(IPath location) {
        int resultProjectPathSegments = 0;
        IFile result = null;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects(8);
        int i = 0;
        while (i < projects.length) {
            IPath path;
            IFile resource;
            int segmentsToRemove;
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf(location) && (segmentsToRemove = projectLocation.segmentCount()) > resultProjectPathSegments && (resource = M2eUtils.resourceFor(path = project.getFullPath().append(location.removeFirstSegments(segmentsToRemove)))) != null && !((Resource)resource).isFiltered()) {
                resultProjectPathSegments = segmentsToRemove;
                result = resource;
            }
            ++i;
        }
        return result;
    }

    private static IFile resourceFor(IPath path) {
        int numSegments = path.segmentCount();
        if (numSegments < 2) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }
}

