/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.beans.ui.live.model.LiveBeansModel;
import org.springframework.ide.eclipse.beans.ui.livegraph.actions.ConnectToApplicationDialog;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansModelGenerator;
import org.springframework.ide.eclipse.beans.ui.livegraph.views.LiveBeansGraphView;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class ConnectToApplicationAction
extends Action {
    private final LiveBeansGraphView view;
    private final ConnectToApplicationDialog dialog;

    public ConnectToApplicationAction(LiveBeansGraphView view) {
        super("Connect to Application...");
        this.view = view;
        this.dialog = new ConnectToApplicationDialog(view.getSite().getShell());
    }

    public void run() {
        if (this.dialog.open() == 0) {
            try {
                LiveBeansModel model = LiveBeansModelGenerator.connectToModel(this.dialog.getServiceUrl(), this.dialog.getUsername(), this.dialog.getPassword(), this.dialog.getApplicationName(), null);
                this.view.setInput(model);
            }
            catch (CoreException e) {
                Status status = new Status(1, "org.springframework.ide.eclipse.beans.ui.livegraph", e.getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)this.dialog.getShell(), (String)"Connection Failed", (String)"Could not connect to the given server or application.\n\nPlease ensure that the server is configured for JMX access and that the host name and port are correct. If the server requires authentication, please provide a username and password. This feature is only supported for applications on Spring Framework 3.2 or greater.\n\nSee the Error Log for more details.", (IStatus)status);
                StatusHandler.log((IStatus)status);
            }
        }
    }
}

