/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.ui;

import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingView;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingViewLabelProvider;
import org.springframework.util.AntPathMatcher;

public class RequestMappingViewSorter
extends ViewerSorter {
    private RequestMappingViewLabelProvider labelProvider;
    private AntPathMatcher matcher = new AntPathMatcher();
    private int sortColumn;
    private int sortDirection;

    public RequestMappingViewSorter(RequestMappingViewLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result = this.compareColumn(viewer, e1, e2);
        if (this.sortDirection == 128) {
            return result;
        }
        return result * -1;
    }

    public void setSortColumn(int column) {
        this.sortColumn = column;
    }

    public void setSortDirection(int direction) {
        this.sortDirection = direction;
    }

    private int compareColumn(Viewer viewer, Object e1, Object e2) {
        if (this.sortColumn == RequestMappingView.COLUMN_URL) {
            return this.sortByUrl(e1, e2);
        }
        if (this.sortColumn == RequestMappingView.COLUMN_REQUEST_METHOD) {
            int result = this.sortByRequestMethod(e1, e2);
            if (result == 0) {
                result = this.sortByHandlerMethod(e1, e2);
            }
            return result;
        }
        if (this.sortColumn == RequestMappingView.COLUMN_HANDLER_METHOD) {
            return this.sortByHandlerMethod(e1, e2);
        }
        return 0;
    }

    private int sortByHandlerMethod(Object e1, Object e2) {
        String str1 = this.labelProvider.getColumnText(e1, RequestMappingView.COLUMN_HANDLER_METHOD);
        String str2 = this.labelProvider.getColumnText(e2, RequestMappingView.COLUMN_HANDLER_METHOD);
        return str1.compareTo(str2);
    }

    private int sortByRequestMethod(Object e1, Object e2) {
        String str1 = this.labelProvider.getColumnText(e1, RequestMappingView.COLUMN_REQUEST_METHOD);
        String str2 = this.labelProvider.getColumnText(e2, RequestMappingView.COLUMN_REQUEST_METHOD);
        return str1.compareTo(str2);
    }

    private int sortByUrl(Object e1, Object e2) {
        String str1 = this.labelProvider.getColumnText(e1, RequestMappingView.COLUMN_URL);
        String str2 = this.labelProvider.getColumnText(e2, RequestMappingView.COLUMN_URL);
        String prefix = this.getCommonPrefix(str1, str2);
        str1 = str1.substring(prefix.length(), str1.length());
        str2 = str2.substring(prefix.length(), str2.length());
        if (str1.startsWith("*")) {
            str1 = "/" + str1;
        }
        if (str2.startsWith("*")) {
            str2 = "/" + str2;
        }
        Comparator comparator = this.matcher.getPatternComparator(prefix);
        if (prefix.length() > 1 && (this.matcher.isPattern(str1) || str1.contains("{") || this.matcher.isPattern(str2) || str2.contains("{"))) {
            return comparator.compare(str1, str2);
        }
        int strResult = str1.compareTo(str2);
        if (strResult == 0) {
            strResult = this.sortByHandlerMethod(e1, e2);
        }
        return strResult;
    }

    private String getCommonPrefix(String str1, String str2) {
        if (str1.equals(str2)) {
            return str1;
        }
        String prefix = "";
        int i = 0;
        while (i < str1.length() && i < str2.length()) {
            String s = str1.substring(i, i + 1);
            if (!s.equals(str2.substring(i, i + 1))) break;
            prefix = prefix.concat(s);
            ++i;
        }
        return prefix;
    }
}

