/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.ui;

import java.util.Set;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMemberValuePair;
import org.springframework.ide.eclipse.metadata.core.RequestMappingAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.RequestMappingMethodAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingMethodToClassMap;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingView;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class RequestMappingViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private AntPathMatcher matcher = new AntPathMatcher();
    private JavaElementLabelProvider javaLabelProvider = new JavaElementLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof RequestMappingMethodToClassMap && columnIndex == RequestMappingView.COLUMN_HANDLER_METHOD) {
            RequestMappingMethodAnnotationMetadata annotation = ((RequestMappingMethodToClassMap)element).getMethodMetadata();
            IMethod method = (IMethod)JdtUtils.getByHandle((String)annotation.getHandleIdentifier());
            return this.javaLabelProvider.getImage((Object)method);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof RequestMappingAnnotationMetadata && columnIndex == RequestMappingView.COLUMN_URL) {
            return this.getClassUrl((RequestMappingAnnotationMetadata)((Object)element));
        }
        if (element instanceof RequestMappingMethodToClassMap) {
            if (columnIndex == RequestMappingView.COLUMN_URL) {
                return this.getMethodUrl((RequestMappingMethodToClassMap)element);
            }
            if (columnIndex == RequestMappingView.COLUMN_REQUEST_METHOD) {
                return this.getRequestMethod((RequestMappingMethodToClassMap)element);
            }
            if (columnIndex == RequestMappingView.COLUMN_HANDLER_METHOD) {
                return this.getHandlerMethod((RequestMappingMethodToClassMap)element);
            }
        }
        return "";
    }

    private String getClassUrl(RequestMappingAnnotationMetadata annotation) {
        Object value = annotation.getValue();
        if (value instanceof Set) {
            for (AnnotationMemberValuePair pair : (Set)value) {
                if (pair.getName() != null) continue;
                String url = pair.getValue();
                if (url.endsWith("/**")) {
                    url = url.substring(0, url.length() - 3);
                }
                if (!url.startsWith("/")) {
                    url = "/".concat(url);
                }
                return url;
            }
        }
        return "/";
    }

    private String getMethodUrl(RequestMappingMethodToClassMap map) {
        RequestMappingMethodAnnotationMetadata annotation = map.getMethodMetadata();
        String classUrl = this.getClassUrl(map.getClassMetadata());
        Object value = annotation.getValue();
        if (value instanceof Set) {
            for (AnnotationMemberValuePair pair : (Set)value) {
                if (pair.getName() != null) continue;
                if (classUrl.equals("/") && pair.getValue().startsWith("/")) {
                    return pair.getValue();
                }
                String url = this.matcher.combine(classUrl, pair.getValue());
                if (url.contains("/**/")) {
                    url = StringUtils.delete((String)url, (String)"/**");
                }
                return url;
            }
        }
        return classUrl;
    }

    private String extractMethodFromAnnotation(IBeanMetadata metadata) {
        Object value = metadata.getValue();
        if (value instanceof Set) {
            for (AnnotationMemberValuePair pair : (Set)value) {
                if (!"method".equalsIgnoreCase(pair.getName())) continue;
                String method = pair.getValue();
                if (method.startsWith("RequestMethod.")) {
                    return method.substring("RequestMethod.".length());
                }
                return method;
            }
        }
        return null;
    }

    private String getRequestMethod(RequestMappingMethodToClassMap map) {
        RequestMappingMethodAnnotationMetadata annotation = map.getMethodMetadata();
        String classMethod = this.extractMethodFromAnnotation((IBeanMetadata)map.getClassMetadata());
        String requestMethod = this.extractMethodFromAnnotation((IBeanMetadata)annotation);
        if (requestMethod != null) {
            return requestMethod;
        }
        if (classMethod != null) {
            return classMethod;
        }
        return "";
    }

    private String getHandlerMethod(RequestMappingMethodToClassMap map) {
        RequestMappingMethodAnnotationMetadata annotation = map.getMethodMetadata();
        IMethod method = (IMethod)JdtUtils.getByHandle((String)annotation.getHandleIdentifier());
        return String.valueOf(this.javaLabelProvider.getText((Object)method.getDeclaringType())) + "." + this.javaLabelProvider.getText((Object)method);
    }
}

