/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.metadata.MetadataUIImages;
import org.springframework.ide.eclipse.metadata.actions.Messages;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingBeanMetadataReference;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingView;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class ShowRequestMappingsAction
extends AbstractNavigatorAction
implements IActionDelegate {
    private IBeansModelElement element;

    public ShowRequestMappingsAction() {
        this(null);
    }

    public ShowRequestMappingsAction(ICommonActionExtensionSite actionSite) {
        super(actionSite);
        this.setText(Messages.ShowRequestMappingsAction_TITLE);
        this.setImageDescriptor(MetadataUIImages.DESC_OBJS_REQUEST_MAPPING);
    }

    protected boolean isEnabled(IStructuredSelection selection) {
        Object treeElement = selection.getFirstElement();
        IBeansProject modelElement = null;
        if (treeElement instanceof IBeansProject) {
            modelElement = (IBeansProject)treeElement;
        } else if (treeElement instanceof IBeansConfig) {
            modelElement = (IBeansConfig)treeElement;
        } else if (treeElement instanceof IBeansConfigSet) {
            modelElement = (IBeansConfigSet)treeElement;
        } else if (treeElement instanceof IProject) {
            modelElement = BeansCorePlugin.getModel().getProject((IProject)treeElement);
        } else if (treeElement instanceof IFile) {
            modelElement = BeansCorePlugin.getModel().getConfig((IFile)treeElement);
        } else if (treeElement instanceof RequestMappingBeanMetadataReference) {
            modelElement = ((RequestMappingBeanMetadataReference)((Object)treeElement)).getBeansProject();
        }
        if (modelElement != null) {
            this.element = modelElement;
            return true;
        }
        return false;
    }

    public void run() {
        this.displayView();
    }

    private void displayView() {
        try {
            RequestMappingView view = (RequestMappingView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.springsource.sts.ide.metadata.ui.RequestMappingView");
            view.setInput(this.element);
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.metadata", String.valueOf(Messages.ShowRequestMappingsAction_ERROR_OPENING_VIEW) + "com.springsource.sts.ide.metadata.ui.RequestMappingView", (Throwable)e));
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.isEnabled((IStructuredSelection)selection);
        }
    }
}

