/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractConnectionCreateCommand;
import org.springframework.ide.eclipse.config.graph.parts.FixedConnectionAnchor;

public abstract class FixedConnectionCreateCommand
extends AbstractConnectionCreateCommand {
    protected String oldId;
    protected String id;
    private String attr = null;
    protected FixedConnectionAnchor sourceAnchor = null;
    protected FixedConnectionAnchor targetAnchor = null;

    public FixedConnectionCreateCommand(ITextEditor textEditor, int lineStyle) {
        super(textEditor, lineStyle);
    }

    @Override
    public boolean canExecute() {
        if (super.canExecute()) {
            if (this.sourceAnchor == null && this.targetAnchor == null) {
                return false;
            }
            if (this.sourceAnchor != null && this.targetAnchor != null) {
                return this.doesCreateNewElement();
            }
            if (this.sourceAnchor != null) {
                this.attr = this.sourceAnchor.getConnectionLabel();
                this.oldId = this.sourceElement.getAttribute(this.attr);
                this.id = this.targetElement.getAttribute(BeansSchemaConstants.ATTR_ID);
            } else {
                this.attr = this.targetAnchor.getConnectionLabel();
                this.oldId = this.targetElement.getAttribute(this.attr);
                this.id = this.sourceElement.getAttribute(BeansSchemaConstants.ATTR_ID);
            }
            if (this.id != null && this.id.trim().length() != 0) {
                return true;
            }
        }
        return false;
    }

    protected abstract void createNewElement();

    protected abstract boolean doesCreateNewElement();

    public void execute() {
        if (this.sourceAnchor != null && this.targetAnchor != null && this.doesCreateNewElement()) {
            this.createNewElement();
        } else if (this.sourceAnchor != null) {
            this.sourceElement.setAttribute(this.attr, this.id);
        } else {
            this.targetElement.setAttribute(this.attr, this.id);
        }
    }

    public void setSourceAnchor(FixedConnectionAnchor anchor) {
        this.sourceAnchor = anchor;
    }

    public void setTargetAnchor(FixedConnectionAnchor anchor) {
        this.targetAnchor = anchor;
    }
}

