/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.properties.XMLPropertySource;
import org.springframework.ide.eclipse.config.graph.model.AbstractGefGraphModelElement;
import org.springframework.ide.eclipse.config.graph.model.Activity;

public class Transition
extends AbstractGefGraphModelElement
implements IAdaptable {
    public static final Integer SOLID_CONNECTION = new Integer(1);
    public static final Integer DASHED_CONNECTION = new Integer(2);
    private int lineStyle;
    private boolean isDirectional;
    public Activity source;
    public Activity target;
    private IDOMNode input;

    public Transition(Activity source, Activity target) {
        this(source, target, null);
    }

    public Transition(Activity source, Activity target, IDOMNode input) {
        this(source, target, input, 1, true);
    }

    public Transition(Activity source, Activity target, IDOMNode input, int style, boolean isDirectional) {
        this.input = input;
        this.source = source;
        this.target = target;
        this.isDirectional = isDirectional;
        this.lineStyle = style;
        if (!source.equals(target)) {
            source.addOutgoing(this);
            target.addIncoming(this);
        }
    }

    public Transition(Activity source, Activity target, IDOMNode input, boolean isDirectional) {
        this(source, target, input, 1, isDirectional);
    }

    public Transition(Activity source, Activity target, IDOMNode input, int style) {
        this(source, target, input, style, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transition)) {
            return false;
        }
        Transition other = (Transition)obj;
        if (this.input == null ? other.input != null : !this.input.equals(other.input)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySource.class == adapter) {
            IPropertySource propertySource = (IPropertySource)this.input.getAdapterFor(IPropertySource.class);
            if (propertySource == null) {
                propertySource = new XMLPropertySource((INodeNotifier)this.input);
            }
            return propertySource;
        }
        return null;
    }

    public IDOMNode getInput() {
        return this.input;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean isDirectional() {
        return this.isDirectional;
    }

    public void setInput(IDOMNode input) {
        this.input = input;
    }

    public void setIsDirectional(boolean isDirectional) {
        this.isDirectional = isDirectional;
    }

    public void setLineStyle(int lineStyle) {
        if (lineStyle == 1 || lineStyle == 2) {
            this.lineStyle = lineStyle;
            this.firePropertyChange("linestyle", null, new Integer(this.lineStyle));
        }
    }
}

