/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.graph.AbstractConfigGraphicalEditor;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.IDiagramModelFactory;
import org.springframework.ide.eclipse.config.graph.model.IModelFactory;
import org.springframework.ide.eclipse.config.graph.model.Messages;
import org.springframework.ide.eclipse.config.graph.model.ParallelActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractConfigGraphDiagram
extends ParallelActivity {
    private static String KEY_COORDINATES = "coordinates";
    private static String KEY_ELEMENT = "element";
    private static String KEY_ELEMENT_TYPE = "type";
    private static String KEY_STRUCTURE = "structure";
    private static String KEY_STRUCTURE_START = "start";
    private static String KEY_STRUCTURE_STARTEND = "startend";
    private static String KEY_STRUCTURE_ENDSTART = "endstart";
    private static String KEY_STRUCTURE_END = "end";
    private static String KEY_BOUNDS = "bounds";
    private static String KEY_BOUNDS_X = "x";
    private static String KEY_BOUNDS_Y = "y";
    private static String KEY_BOUNDS_HEIGHT = "height";
    private static String KEY_BOUNDS_WIDTH = "width";
    private static String KEY_MODEL_CLASS = "clazz";
    private final AbstractConfigGraphicalEditor editor;
    private final List<Activity> modelRegistry;
    private Map<String, Node> refNodeRegistry;

    public AbstractConfigGraphDiagram(AbstractConfigGraphicalEditor editor) {
        this.editor = editor;
        this.modelRegistry = new ArrayList<Activity>();
        this.refNodeRegistry = new HashMap<String, Node>();
    }

    @Override
    protected void createInput(String uri) {
    }

    public Rectangle doReadCoordinates(Activity activity) {
        String xml = this.getPreferenceLocation().getString(this.getGraphCoordsKey(), "");
        Rectangle savedBounds = null;
        if (xml != null && xml.length() > 0) {
            try {
                IMemento[] elementMementos;
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(xml));
                IMemento[] iMementoArray = elementMementos = memento.getChildren(KEY_ELEMENT);
                int n = elementMementos.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento structureMemento;
                    IMemento element = iMementoArray[n2];
                    IDOMElement input = activity.getInput();
                    if (activity.getInputName().equals(element.getString(KEY_ELEMENT_TYPE)) && activity.getClass().getSimpleName().equals(element.getString(KEY_MODEL_CLASS)) && (structureMemento = element.getChild(KEY_STRUCTURE)) != null && structureMemento.getInteger(KEY_STRUCTURE_START).equals(input.getStartOffset()) && structureMemento.getInteger(KEY_STRUCTURE_STARTEND).equals(input.getStartEndOffset()) && structureMemento.getInteger(KEY_STRUCTURE_ENDSTART).equals(input.getEndStartOffset()) && structureMemento.getInteger(KEY_STRUCTURE_END).equals(input.getEndOffset())) {
                        IMemento boundsMemento = element.getChild(KEY_BOUNDS);
                        savedBounds = new Rectangle(boundsMemento.getInteger(KEY_BOUNDS_X).intValue(), boundsMemento.getInteger(KEY_BOUNDS_Y).intValue(), boundsMemento.getInteger(KEY_BOUNDS_WIDTH).intValue(), boundsMemento.getInteger(KEY_BOUNDS_HEIGHT).intValue());
                    }
                    ++n2;
                }
            }
            catch (WorkbenchException workbenchException) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.graph", Messages.AbstractConfigFlowDiagram_ERROR_READING_COORDINATES));
            }
        }
        return savedBounds;
    }

    public void doResetCoordinates() {
        this.getPreferenceLocation().putString(this.getGraphCoordsKey(), "");
    }

    public void doSaveCoordinates() {
        String xml = null;
        XMLMemento memento = XMLMemento.createWriteRoot((String)"graph");
        for (Activity child : this.children) {
            IMemento childMemento = memento.createChild(KEY_ELEMENT);
            childMemento.putString(KEY_ELEMENT_TYPE, child.getInputName());
            childMemento.putString(KEY_MODEL_CLASS, child.getClass().getSimpleName());
            IDOMElement input = child.getInput();
            IMemento structureMemento = childMemento.createChild(KEY_STRUCTURE);
            structureMemento.putInteger(KEY_STRUCTURE_START, input.getStartOffset());
            structureMemento.putInteger(KEY_STRUCTURE_STARTEND, input.getStartEndOffset());
            structureMemento.putInteger(KEY_STRUCTURE_ENDSTART, input.getEndStartOffset());
            structureMemento.putInteger(KEY_STRUCTURE_END, input.getEndOffset());
            Rectangle bounds = child.getBounds();
            IMemento boundsMemento = childMemento.createChild(KEY_BOUNDS);
            boundsMemento.putInteger(KEY_BOUNDS_X, bounds.x);
            boundsMemento.putInteger(KEY_BOUNDS_Y, bounds.y);
            boundsMemento.putInteger(KEY_BOUNDS_HEIGHT, bounds.height);
            boundsMemento.putInteger(KEY_BOUNDS_WIDTH, bounds.width);
        }
        try {
            StringWriter writer = new StringWriter();
            memento.save((Writer)writer);
            xml = writer.getBuffer().toString();
            this.getPreferenceLocation().putString(this.getGraphCoordsKey(), xml);
        }
        catch (IOException iOException) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.graph", Messages.AbstractConfigFlowDiagram_ERROR_SAVING_COORDINATES));
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IPropertySource.class == adapter) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected List<Activity> getChildrenFromXml() {
        List<Activity> list = super.getChildrenFromXml();
        list.addAll(this.getNestedChildrenFromXml(this.getInput()));
        return list;
    }

    @Override
    public AbstractConfigGraphDiagram getDiagram() {
        return this;
    }

    public IDOMDocument getDomDocument() {
        return this.editor.getDomDocument();
    }

    private String getGraphCoordsKey() {
        return String.valueOf(KEY_COORDINATES) + ":" + this.getNamespaceUri() + ":" + this.getResourceFile().getFullPath().toString();
    }

    public AbstractConfigGraphicalEditor getGraphicalEditor() {
        return this.editor;
    }

    @Override
    public IDOMElement getInput() {
        return (IDOMElement)this.getDomDocument().getDocumentElement();
    }

    @Override
    public String getInputName() {
        return "";
    }

    protected abstract IDiagramModelFactory getModelFactory();

    @Override
    public List<Activity> getModelRegistry() {
        return this.modelRegistry;
    }

    public String getNamespaceUri() {
        return this.editor.getNamespaceUri();
    }

    private List<Activity> getNestedChildrenFromXml(IDOMElement parent) {
        ArrayList<Activity> list = new ArrayList<Activity>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof IDOMElement) {
                IDOMElement childElem = (IDOMElement)child;
                if (this.getNamespaceUri() != null && this.getNamespaceUri().equals(child.getNamespaceURI())) {
                    this.getModelFactory().getNestedChildrenFromXml(list, childElem, this);
                } else {
                    for (IConfigurationElement config : this.editor.getAdapterDefinitions()) {
                        String uri = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI);
                        if (!uri.equals(child.getNamespaceURI())) continue;
                        try {
                            Object obj = config.createExecutableExtension(PageAdaptersExtensionPointConstants.ATTR_MODEL_FACTORY);
                            if (!(obj instanceof IModelFactory)) continue;
                            IModelFactory factory = (IModelFactory)obj;
                            factory.getNestedChildrenFromXml(list, childElem, this);
                        }
                        catch (CoreException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.graph", Messages.AbstractConfigFlowDiagram_ERROR_CREATING_GRAPH, (Throwable)e));
                        }
                    }
                }
                if (child.hasChildNodes()) {
                    list.addAll(this.getNestedChildrenFromXml(childElem));
                }
            }
            ++i;
        }
        return list;
    }

    private SpringCorePreferences getPreferenceLocation() {
        IFile resource = this.getResourceFile();
        SpringCorePreferences prefs = SpringCorePreferences.getProjectPreferences((IProject)resource.getProject(), (String)"com.springsource.sts.config.flow");
        return prefs;
    }

    public Node getReferencedNode(String ref) {
        if (ref == null || ref.length() <= 0) {
            return null;
        }
        return this.refNodeRegistry.get(ref);
    }

    public IFile getResourceFile() {
        return this.editor.getResourceFile();
    }

    public StructuredTextEditor getTextEditor() {
        return this.editor.getEditor().getSourcePage();
    }

    protected void getTransitionsFromXml(Activity source, Activity target, List<Transition> transitions, List<String> attrs, boolean incoming, boolean primary) {
        for (String label : attrs) {
            Node ref;
            Attr attr = source.getInput().getAttributeNode(label);
            if (!(attr instanceof IDOMAttr) || !((ref = this.getReferencedNode(attr.getValue())) instanceof IDOMElement) || !target.getInput().equals(ref)) continue;
            Transition trans = incoming ? new Transition(target, source, (IDOMNode)((IDOMAttr)attr)) : new Transition(source, target, (IDOMNode)((IDOMAttr)attr));
            if (!primary) {
                trans.setLineStyle(Transition.DASHED_CONNECTION);
            }
            transitions.add(trans);
        }
    }

    protected SpringConfigContentAssistProcessor getXmlProcessor() {
        return this.editor.getXmlProcessor();
    }

    @Override
    protected void internalSetName() {
        this.setName("diagram");
    }

    public boolean listContainsElement(List<Activity> list, Activity element) {
        for (Activity activity : list) {
            if (!activity.getClass().equals(element.getClass()) || activity.getInput() == null || !activity.getInput().equals(element.getInput())) continue;
            return true;
        }
        return false;
    }

    public void refreshModelFromXml() {
        this.modelRegistry.clear();
        this.updateRefNodeRegistry();
        this.updateChildrenFromXml();
        this.updateTransitionsFromXml();
    }

    @Override
    public void setInput(IDOMElement input) {
    }

    private void updateRefNodeRegistry() {
        this.refNodeRegistry = BeansEditorUtils.getReferenceableNodes((Document)this.getDomDocument(), (IFile)this.getResourceFile());
    }
}

