/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.webflow.core.internal.model.IfTransition;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.Activator;

public class DeleteCommand
extends Command {
    private IState child;
    private int index = -1;
    private IWebflowState parent;
    private List<ITransition> sourceConnections = new ArrayList<ITransition>();
    private List<ITransition> targetConnections = new ArrayList<ITransition>();
    private boolean undo = true;

    public boolean canUndo() {
        return this.undo;
    }

    private void deleteConnections(IState a) {
        if (a instanceof IWebflowState) {
            List children = ((IWebflowState)a).getStates();
            int i = 0;
            while (i < children.size()) {
                this.deleteConnections((IState)children.get(i));
                ++i;
            }
        }
        if (a instanceof ITransitionableFrom) {
            this.sourceConnections.addAll(((ITransitionableFrom)a).getOutputTransitions());
            int i = 0;
            while (i < this.sourceConnections.size()) {
                ITransition t = this.sourceConnections.get(i);
                ((ITransitionableFrom)a).removeOutputTransition(t);
                t.getToState().removeInputTransition(t);
                ++i;
            }
        }
        if (a instanceof ITransitionableTo) {
            this.targetConnections.addAll(((ITransitionableTo)a).getInputTransitions());
        }
        int i = 0;
        while (i < this.targetConnections.size()) {
            if (this.targetConnections.get(i) instanceof IStateTransition) {
                IStateTransition t = (IStateTransition)this.targetConnections.get(i);
                t.getFromState().removeOutputTransition((ITransition)t);
                ((ITransitionableTo)a).removeInputTransition((ITransition)t);
            } else if (this.targetConnections.get(i) instanceof IfTransition) {
                IfTransition t = (IfTransition)this.targetConnections.get(i);
                if (t.isThen()) {
                    t.getFromIf().removeThenTransition();
                } else {
                    t.getFromIf().removeElseTransition();
                }
                ((ITransitionableTo)a).removeInputTransition((ITransition)t);
            }
            ++i;
        }
    }

    public void execute() {
        if (this.child instanceof IDecisionState && ((IDecisionState)this.child).getIfs().size() > 0) {
            MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error deleting state", (String)("The decision state '" + this.child.getId() + "' has at least one if criteria. \n\nPlease delete all if criterias before deleting the decision state."));
            this.undo = false;
            return;
        }
        if (this.child instanceof ITransitionableTo) {
            ITransitionableTo to = (ITransitionableTo)this.child;
            int i = 0;
            while (i < to.getInputTransitions().size()) {
                ITransition tran = (ITransition)to.getInputTransitions().get(i);
                if (tran instanceof IIfTransition && ((IIfTransition)tran).isThen()) {
                    MessageDialog.openError((Shell)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error deleting state", (String)("The state '" + this.child.getId() + "' has at least one incoming transition from an if criteria. \n\nRetry the deletion after retargeting the if criteria's then target to another state."));
                    this.undo = false;
                    return;
                }
                ++i;
            }
        }
        this.primExecute();
    }

    protected void primExecute() {
        this.deleteConnections(this.child);
        if (this.child instanceof IInlineFlowState) {
            this.index = this.parent.getInlineFlowStates().indexOf(this.child);
            this.parent.removeInlineFlowState((IInlineFlowState)this.child);
        } else {
            this.index = this.parent.getStates().indexOf(this.child);
            this.parent.removeState(this.child);
        }
    }

    public void redo() {
        this.primExecute();
    }

    private void restoreConnections() {
        IStateTransition t;
        int i = 0;
        while (i < this.sourceConnections.size()) {
            t = (IStateTransition)this.sourceConnections.get(i);
            t.getToState().addInputTransition((ITransition)t);
            t.getFromState().addOutputTransition((ITransition)t);
            ++i;
        }
        this.sourceConnections.clear();
        i = 0;
        while (i < this.targetConnections.size()) {
            if (this.targetConnections.get(i) instanceof IStateTransition) {
                t = (IStateTransition)this.targetConnections.get(i);
                t.getToState().addInputTransition((ITransition)t);
                t.getFromState().addOutputTransition((ITransition)t);
            } else if (this.targetConnections.get(i) instanceof IIfTransition) {
                t = (IIfTransition)this.targetConnections.get(i);
                t.getToState().addInputTransition((ITransition)t);
                if (t.isThen()) {
                    t.getFromIf().setThenTransition((IIfTransition)t);
                } else {
                    t.getFromIf().setElseTransition((IIfTransition)t);
                }
            }
            ++i;
        }
        this.targetConnections.clear();
    }

    public void setChild(IState a) {
        this.child = a;
    }

    public void setParent(IWebflowModelElement sa) {
        if (sa instanceof IWebflowState) {
            this.parent = (IWebflowState)sa;
        } else if (sa instanceof IInlineFlowState) {
            this.parent = ((IInlineFlowState)sa).getWebFlowState();
        }
    }

    public void undo() {
        if (this.child instanceof IInlineFlowState) {
            this.parent.addInlineFlowState((IInlineFlowState)this.child, this.index);
        } else {
            this.parent.addState(this.child, this.index);
        }
        this.restoreConnections();
    }
}

