/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.springiderules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;

public class AvoidDriverManagerDataSource
implements IValidationRule<IBean, IBeansValidationContext> {
    public static final String INFO_MESSAGE = "Use of DriverManagerDataSource is discouraged in most cases because it does not pool connections. See the Javadoc for more information.";
    private static final String DRIVER_MANAGER_DATASOURCE_CLASS = "org.springframework.jdbc.datasource.DriverManagerDataSource";
    public static final String ERROR_ID = "avoidDriverManagerDataSource";

    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof IBean && ((IBean)element).getClassName() != null;
    }

    public void validate(IBean bean, IBeansValidationContext validationContext, IProgressMonitor progressMonitor) {
        if (DRIVER_MANAGER_DATASOURCE_CLASS.equals(bean.getClassName())) {
            validationContext.info((IResourceModelElement)bean, ERROR_ID, INFO_MESSAGE, new ValidationProblemAttribute[0]);
        }
    }
}

