/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class TextSearchIndex<T> {
    private static final String SPLIT_PATTERN = "\\W";
    private TreeMap<String, List<DictEntry>> termToObj;
    private Map<T, Integer> objToWordFrequency;

    public TextSearchIndex() {
        this.clear();
    }

    public int size() {
        return this.objToWordFrequency.size();
    }

    public boolean isEmpty() {
        return this.objToWordFrequency.isEmpty();
    }

    public void index(T obj, String text) {
        if (this.objToWordFrequency.containsKey(obj)) {
            throw new IllegalArgumentException("Already indexed");
        }
        List<String> terms = TextSearchIndex.tokenize(text);
        this.objToWordFrequency.put(obj, terms.size());
        int i = 0;
        for (String s : terms) {
            this.addToDictionary(s, i, obj);
            ++i;
        }
    }

    public Map<T, Double> search(String query) {
        List<SearchResult> termMatches;
        List<String> terms = TextSearchIndex.tokenize(query);
        if (terms.isEmpty()) {
            return Collections.emptyMap();
        }
        Iterator<String> it = terms.iterator();
        List<SearchResult> matched = this.searchTerm(it.next());
        while (it.hasNext() && !(matched = this.matchPositional(matched, termMatches = this.searchTerm(it.next()), 1)).isEmpty()) {
        }
        return this.prepareResult(matched);
    }

    private List<SearchResult> matchPositional(List<SearchResult> previousMatches, List<SearchResult> termMatches, int maxDistance) {
        LinkedList<SearchResult> matches = new LinkedList<SearchResult>();
        for (SearchResult e1 : previousMatches) {
            for (SearchResult e2 : termMatches) {
                int dist;
                if (!e1.obj.equals(e2.obj) || (dist = e2.lastIdx - e1.lastIdx) <= 0 || dist > maxDistance) continue;
                SearchResult searchResult = e2;
                searchResult.score = searchResult.score + e1.score;
                matches.add(e2);
            }
        }
        return matches;
    }

    private Map<T, Double> prepareResult(List<SearchResult> entries) {
        HashMap<Object, Double> objToScore = new HashMap<Object, Double>();
        for (SearchResult e : entries) {
            double score = e.score / (double)this.objToWordFrequency.get(e.obj).intValue();
            Double previousScore = (Double)objToScore.get(e.obj);
            if (previousScore != null && !(previousScore < score)) continue;
            objToScore.put(e.obj, score);
        }
        return objToScore.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private List<SearchResult> searchTerm(String termPrefix) {
        LinkedList<SearchResult> entries = new LinkedList<SearchResult>();
        SortedMap<String, List<DictEntry>> tailMap = this.termToObj.tailMap(termPrefix);
        for (Map.Entry<String, List<DictEntry>> e : tailMap.entrySet()) {
            if (!e.getKey().startsWith(termPrefix)) break;
            double score = (double)termPrefix.length() / (double)e.getKey().length();
            e.getValue().stream().map(v -> new SearchResult(score, v.obj, v.tokenIndex)).forEach(entries::add);
        }
        return entries;
    }

    public void clear() {
        this.termToObj = new TreeMap();
        this.objToWordFrequency = new HashMap<T, Integer>();
    }

    public Set<String> getTokens() {
        return Collections.unmodifiableSet(this.termToObj.keySet());
    }

    private void addToDictionary(String token, int tokenIndex, T obj) {
        List<DictEntry> entries = this.termToObj.get(token);
        if (entries == null) {
            entries = new LinkedList<DictEntry>();
            this.termToObj.put(token, entries);
        }
        entries.add(new DictEntry(obj, tokenIndex));
    }

    private static List<String> tokenize(String text) {
        String[] split = text.split(SPLIT_PATTERN);
        ArrayList<String> terms = new ArrayList<String>(split.length);
        for (String s : split) {
            if (s.isEmpty()) continue;
            terms.add(s.toLowerCase(Locale.ENGLISH));
        }
        return terms;
    }

    private class DictEntry {
        T obj;
        int tokenIndex;

        public DictEntry(T obj, int tokenIndex) {
            this.obj = obj;
            this.tokenIndex = tokenIndex;
        }
    }

    private class SearchResult {
        private double score;
        private T obj;
        private int lastIdx;

        public SearchResult(double score, T obj, int lastIdx) {
            this.score = score;
            this.obj = obj;
            this.lastIdx = lastIdx;
        }
    }
}

