/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class FileUtils {
    private static final String PATH_SEPARATOR_PATTERN = Pattern.quote(File.separator);

    private FileUtils() {
    }

    public static void moveDir(Path src, Path dest) {
        try {
            FileUtils.moveDirPreferAtomic(src, dest);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to move " + src + " to " + dest, e);
        }
    }

    private static void moveDirPreferAtomic(Path src, Path dest) throws IOException {
        try {
            Files.move(src, dest, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.walkFileTree(src, new CopyRecursivelyVisitor(src, dest, new CopyOption[0]));
            FileUtils.deleteRecursively(src);
        }
    }

    public static void deleteRecursively(Path path) {
        if (!path.toFile().exists()) {
            return;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to delete directory " + path, e);
        }
    }

    public static void mkdirs(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create directory: " + path, e);
        }
    }

    public static String toSonarQubePath(String path) {
        if (File.separatorChar != '/') {
            return path.replaceAll(PATH_SEPARATOR_PATTERN, "/");
        }
        return path;
    }

    public static void replaceDir(Consumer<Path> dirContentUpdater, Path target, Path work) {
        dirContentUpdater.accept(work);
        FileUtils.deleteRecursively(target);
        FileUtils.mkdirs(target.getParent());
        FileUtils.moveDir(work, target);
    }

    private static class CopyRecursivelyVisitor
    extends SimpleFileVisitor<Path> {
        private final Path fromPath;
        private final Path toPath;
        private final CopyOption[] copyOptions;

        public CopyRecursivelyVisitor(Path fromPath, Path toPath, CopyOption ... copyOptions) {
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.copyOptions = copyOptions;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
            if (!Files.exists(targetPath, new LinkOption[0])) {
                Files.createDirectory(targetPath, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.copyOptions);
            return FileVisitResult.CONTINUE;
        }
    }
}

